/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.token.propagation.common.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.oidc.token.propagation.common.deployment.AccessTokenInstanceBuildItem;
import jakarta.annotation.Priority;
import jakarta.inject.Singleton;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;

public final class AccessTokenRequestFilterGenerator {
    private static final int AUTHENTICATION = 1000;
    private final BuildProducer<UnremovableBeanBuildItem> unremovableBeansProducer;
    private final BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer;
    private final BuildProducer<GeneratedBeanBuildItem> generatedBeanProducer;
    private final Class<?> requestFilterClass;
    private final Map<ClientNameAndExchangeToken, String> cache = new HashMap<ClientNameAndExchangeToken, String>();

    public AccessTokenRequestFilterGenerator(BuildProducer<UnremovableBeanBuildItem> unremovableBeansProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer, BuildProducer<GeneratedBeanBuildItem> generatedBeanProducer, Class<?> requestFilterClass) {
        this.unremovableBeansProducer = unremovableBeansProducer;
        this.reflectiveClassProducer = reflectiveClassProducer;
        this.generatedBeanProducer = generatedBeanProducer;
        this.requestFilterClass = requestFilterClass;
    }

    public String generateClass(AccessTokenInstanceBuildItem instance) {
        return this.cache.computeIfAbsent(new ClientNameAndExchangeToken(instance.getClientName(), instance.exchangeTokenActivated()), i -> {
            String className;
            block20: {
                GeneratedBeanGizmoAdaptor adaptor = new GeneratedBeanGizmoAdaptor(this.generatedBeanProducer);
                className = this.createUniqueClassName((ClientNameAndExchangeToken)i);
                try (ClassCreator classCreator = ClassCreator.builder().className(className).superClass(this.requestFilterClass).classOutput((ClassOutput)adaptor).build();){
                    MethodCreator methodCreator;
                    classCreator.addAnnotation(Priority.class).add("value", (Object)1000);
                    classCreator.addAnnotation(Singleton.class);
                    if (!i.clientName().isEmpty()) {
                        methodCreator = classCreator.getMethodCreator("getClientName", String.class, new Class[0]);
                        try {
                            methodCreator.addAnnotation(Override.class.getName(), RetentionPolicy.CLASS);
                            methodCreator.setModifiers(4);
                            methodCreator.returnValue(methodCreator.load(i.clientName()));
                        }
                        finally {
                            if (methodCreator != null) {
                                methodCreator.close();
                            }
                        }
                    }
                    if (!i.exchangeTokenActivated()) break block20;
                    methodCreator = classCreator.getMethodCreator("isExchangeToken", Boolean.TYPE, new Class[0]);
                    try {
                        methodCreator.addAnnotation(Override.class.getName(), RetentionPolicy.CLASS);
                        methodCreator.setModifiers(4);
                        methodCreator.returnBoolean(true);
                    }
                    finally {
                        if (methodCreator != null) {
                            methodCreator.close();
                        }
                    }
                }
            }
            this.unremovableBeansProducer.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])new String[]{className}));
            this.reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{className}).reason(this.getClass().getName()).methods().fields().constructors().build());
            return className;
        });
    }

    private String createUniqueClassName(ClientNameAndExchangeToken i) {
        return "%s_%sClient_%sTokenExchange".formatted(this.requestFilterClass.getName(), AccessTokenRequestFilterGenerator.clientName(i.clientName()), AccessTokenRequestFilterGenerator.exchangeTokenName(i.exchangeTokenActivated()));
    }

    private static String clientName(String clientName) {
        if (clientName.isEmpty()) {
            return "Default";
        }
        return clientName;
    }

    private static String exchangeTokenName(boolean enabled) {
        if (enabled) {
            return "Enabled";
        }
        return "Default";
    }

    private record ClientNameAndExchangeToken(String clientName, boolean exchangeTokenActivated) {
    }
}

