/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.client.runtime;

import io.quarkus.oidc.client.OidcClientConfigBuilder;
import io.quarkus.oidc.client.runtime.OidcClientsConfig;
import io.quarkus.oidc.common.runtime.config.OidcClientCommonConfig;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.WithDefault;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface OidcClientConfig
extends OidcClientCommonConfig {
    public Optional<String> id();

    @WithDefault(value="true")
    public boolean clientEnabled();

    public Optional<List<String>> scopes();

    public Optional<Duration> refreshTokenTimeSkew();

    public Optional<Duration> accessTokenExpiresIn();

    public Optional<Duration> accessTokenExpirySkew();

    @WithDefault(value="false")
    public boolean absoluteExpiresIn();

    public Grant grant();

    @ConfigDocMapKey(value="grant-name")
    public Map<String, Map<String, String>> grantOptions();

    @WithDefault(value="true")
    public boolean earlyTokensAcquisition();

    public Map<String, String> headers();

    public static OidcClientConfigBuilder builder() {
        OidcClientsConfig clientsConfig = (OidcClientsConfig)new SmallRyeConfigBuilder().addDiscoveredConverters().withMapping(OidcClientsConfig.class).build().getConfigMapping(OidcClientsConfig.class);
        return OidcClientConfig.builder(OidcClientsConfig.getDefaultClient(clientsConfig));
    }

    public static OidcClientConfigBuilder builder(OidcClientConfig config) {
        return new OidcClientConfigBuilder(config);
    }

    public static OidcClientConfigBuilder authServerUrl(String authServerUrl) {
        return (OidcClientConfigBuilder)((Object)OidcClientConfig.builder().authServerUrl(authServerUrl));
    }

    public static OidcClientConfigBuilder registrationPath(String registrationPath) {
        return (OidcClientConfigBuilder)((Object)OidcClientConfig.builder().registrationPath(registrationPath));
    }

    public static OidcClientConfigBuilder tokenPath(String tokenPath) {
        return (OidcClientConfigBuilder)((Object)OidcClientConfig.builder().tokenPath(tokenPath));
    }

    public static interface Grant {
        @WithDefault(value="client")
        public Type type();

        @WithDefault(value="access_token")
        public String accessTokenProperty();

        @WithDefault(value="refresh_token")
        public String refreshTokenProperty();

        @WithDefault(value="expires_in")
        public String expiresInProperty();

        @WithDefault(value="refresh_expires_in")
        public String refreshExpiresInProperty();

        public static enum Type {
            CLIENT("client_credentials"),
            PASSWORD("password"),
            CODE("authorization_code"),
            EXCHANGE("urn:ietf:params:oauth:grant-type:token-exchange"),
            JWT("urn:ietf:params:oauth:grant-type:jwt-bearer"),
            REFRESH("refresh_token"),
            CIBA("urn:openid:params:grant-type:ciba"),
            DEVICE("urn:ietf:params:oauth:grant-type:device_code");

            private final String grantType;

            private Type(String grantType) {
                this.grantType = grantType;
            }

            public String getGrantType() {
                return this.grantType;
            }
        }
    }
}

