/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.rest.data.panache.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.mongodb.panache.PanacheMongoRepositoryBase;
import io.quarkus.mongodb.panache.PanacheQuery;
import io.quarkus.mongodb.rest.data.panache.deployment.DataAccessImplementor;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Sort;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;

final class RepositoryDataAccessImplementor
implements DataAccessImplementor {
    private final String repositoryClassName;

    RepositoryDataAccessImplementor(String repositoryClassName) {
        this.repositoryClassName = repositoryClassName;
    }

    @Override
    public ResultHandle findById(BytecodeCreator creator, ResultHandle id) {
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheMongoRepositoryBase.class, (String)"findById", Object.class, (Class[])new Class[]{Object.class}), this.getRepositoryInstance(creator), new ResultHandle[]{id});
    }

    @Override
    public ResultHandle findAll(BytecodeCreator creator, ResultHandle page) {
        ResultHandle panacheQuery = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheMongoRepositoryBase.class, (String)"findAll", PanacheQuery.class, (Class[])new Class[0]), this.getRepositoryInstance(creator), new ResultHandle[0]);
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"page", PanacheQuery.class, (Class[])new Class[]{Page.class}), panacheQuery, new ResultHandle[]{page});
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"list", List.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
    }

    @Override
    public ResultHandle findAll(BytecodeCreator creator, ResultHandle page, ResultHandle sort) {
        ResultHandle panacheQuery = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheMongoRepositoryBase.class, (String)"findAll", PanacheQuery.class, (Class[])new Class[]{Sort.class}), this.getRepositoryInstance(creator), new ResultHandle[]{sort});
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"page", PanacheQuery.class, (Class[])new Class[]{Page.class}), panacheQuery, new ResultHandle[]{page});
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"list", List.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
    }

    @Override
    public ResultHandle findAll(BytecodeCreator creator, ResultHandle page, ResultHandle query, ResultHandle queryParams) {
        ResultHandle panacheQuery = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheMongoRepositoryBase.class, (String)"find", PanacheQuery.class, (Class[])new Class[]{String.class, Map.class}), this.getRepositoryInstance(creator), new ResultHandle[]{query, queryParams});
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"page", PanacheQuery.class, (Class[])new Class[]{Page.class}), panacheQuery, new ResultHandle[]{page});
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"list", List.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
    }

    @Override
    public ResultHandle findAll(BytecodeCreator creator, ResultHandle page, ResultHandle sort, ResultHandle query, ResultHandle queryParams) {
        ResultHandle panacheQuery = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheMongoRepositoryBase.class, (String)"find", PanacheQuery.class, (Class[])new Class[]{String.class, Sort.class, Map.class}), this.getRepositoryInstance(creator), new ResultHandle[]{query, sort, queryParams});
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"page", PanacheQuery.class, (Class[])new Class[]{Page.class}), panacheQuery, new ResultHandle[]{page});
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"list", List.class, (Class[])new Class[0]), panacheQuery, new ResultHandle[0]);
    }

    @Override
    public ResultHandle persist(BytecodeCreator creator, ResultHandle entity) {
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheMongoRepositoryBase.class, (String)"persist", Void.TYPE, (Class[])new Class[]{Object.class}), this.getRepositoryInstance(creator), new ResultHandle[]{entity});
        return entity;
    }

    @Override
    public ResultHandle persistOrUpdate(BytecodeCreator creator, ResultHandle entity) {
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheMongoRepositoryBase.class, (String)"persistOrUpdate", Void.TYPE, (Class[])new Class[]{Object.class}), this.getRepositoryInstance(creator), new ResultHandle[]{entity});
        return entity;
    }

    @Override
    public ResultHandle deleteById(BytecodeCreator creator, ResultHandle id) {
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheMongoRepositoryBase.class, (String)"deleteById", Boolean.TYPE, (Class[])new Class[]{Object.class}), this.getRepositoryInstance(creator), new ResultHandle[]{id});
    }

    @Override
    public ResultHandle pageCount(BytecodeCreator creator, ResultHandle page) {
        ResultHandle query = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheMongoRepositoryBase.class, (String)"findAll", PanacheQuery.class, (Class[])new Class[0]), this.getRepositoryInstance(creator), new ResultHandle[0]);
        creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"page", PanacheQuery.class, (Class[])new Class[]{Page.class}), query, new ResultHandle[]{page});
        return creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(PanacheQuery.class, (String)"pageCount", Integer.TYPE, (Class[])new Class[0]), query, new ResultHandle[0]);
    }

    private ResultHandle getRepositoryInstance(BytecodeCreator creator) {
        ResultHandle arcContainer = creator.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle instanceHandle = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), arcContainer, new ResultHandle[]{creator.loadClassFromTCCL(this.repositoryClassName), creator.newArray(Annotation.class, 0)});
        ResultHandle instance = creator.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
        creator.ifNull(instance).trueBranch().throwException(RuntimeException.class, this.repositoryClassName + " instance was not found");
        return instance;
    }
}

