/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.export.handlers;

import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.vertx.http.runtime.HttpCompressionHandler;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jboss.logging.Logger;

public class PrometheusHandler
implements Handler<RoutingContext> {
    private static final Logger log = Logger.getLogger(PrometheusHandler.class);
    private final boolean enableCompression;
    private final Set<String> compressMediaTypes;
    private PrometheusMeterRegistry registry;
    private boolean setup = false;

    public PrometheusHandler(boolean enableCompression, Optional<List<String>> compressMediaTypes) {
        this.enableCompression = enableCompression;
        this.compressMediaTypes = this.determineCompressMediaTypes(compressMediaTypes);
    }

    private Set<String> determineCompressMediaTypes(Optional<List<String>> maybeCompressMediaTypes) {
        List<String> compressMediaTypes;
        if (maybeCompressMediaTypes.isPresent() && (compressMediaTypes = maybeCompressMediaTypes.get()).contains("text/plain")) {
            return Set.of("text/plain", "application/openmetrics-text");
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(final RoutingContext routingContext) {
        if (!this.setup) {
            this.setup();
        }
        if (this.enableCompression) {
            routingContext.addEndHandler((Handler)new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> result) {
                    if (result.succeeded()) {
                        HttpCompressionHandler.compressIfNeeded((RoutingContext)routingContext, PrometheusHandler.this.compressMediaTypes);
                    }
                }
            });
        }
        HttpServerResponse response = routingContext.response();
        if (this.registry == null) {
            response.setStatusCode(500).setStatusMessage("Unable to resolve Prometheus registry instance");
        } else {
            ManagedContext requestContext = Arc.container().requestContext();
            String acceptHeader = this.chooseContentType(routingContext.request().getHeader("Accept"));
            if (requestContext.isActive()) {
                this.doHandle(response, acceptHeader);
            } else {
                requestContext.activate();
                try {
                    this.doHandle(response, acceptHeader);
                }
                finally {
                    requestContext.terminate();
                }
            }
        }
    }

    private String chooseContentType(String acceptHeader) {
        if (acceptHeader == null) {
            return "application/openmetrics-text; version=1.0.0; charset=utf-8";
        }
        if (acceptHeader.contains("text/plain") || acceptHeader.contains("text/html")) {
            return "text/plain; version=0.0.4; charset=utf-8";
        }
        return "application/openmetrics-text; version=1.0.0; charset=utf-8";
    }

    private void doHandle(HttpServerResponse response, String acceptHeader) {
        response.putHeader("Content-Type", acceptHeader).end(Buffer.buffer((String)this.registry.scrape(acceptHeader)));
    }

    private void setup() {
        Instance registries = CDI.current().select(PrometheusMeterRegistry.class, new Annotation[]{Default.Literal.INSTANCE});
        if (registries.isUnsatisfied()) {
            this.registry = null;
        } else if (registries.isAmbiguous()) {
            this.registry = (PrometheusMeterRegistry)registries.iterator().next();
            log.warnf("Multiple prometheus registries present. Using %s with the built-in scrape endpoint", (Object)this.registry);
        } else {
            this.registry = (PrometheusMeterRegistry)registries.get();
        }
        this.setup = true;
    }
}

