/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.maven.QuarkusBootstrapMojo;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.runtime.LaunchMode;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.Checksum;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="track-config-changes", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class TrackConfigChangesMojo
extends QuarkusBootstrapMojo {
    @Parameter(defaultValue="false", property="quarkus.track-config-changes.skip")
    boolean skip = false;
    @Parameter(property="launchMode")
    String mode;
    @Parameter(property="quarkus.track-config-changes.outputDirectory", defaultValue="${project.build.directory}")
    File outputDirectory;
    @Parameter(property="quarkus.track-config-changes.outputFile", required=false)
    File outputFile;
    @Parameter(property="quarkus.recorded-build-config.directory", defaultValue="${basedir}/.quarkus")
    File recordedBuildConfigDirectory;
    @Parameter(property="quarkus.recorded-build-config.file", required=false)
    File recordedBuildConfigFile;
    @Parameter(defaultValue="false", property="quarkus.track-config-changes.dump-current-when-recorded-unavailable")
    boolean dumpCurrentWhenRecordedUnavailable;
    @Parameter(defaultValue="true", property="quarkus.track-config-changes.dump-dependencies")
    boolean dumpDependencies;
    @Parameter(property="quarkus.track-config-changes.dependencies-file")
    File dependenciesFile;

    @Override
    protected boolean beforeExecute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping config dump");
            return false;
        }
        return true;
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        block30: {
            Path compareFile;
            boolean prevConfigExists;
            String lifecyclePhase = this.mojoExecution.getLifecyclePhase();
            if (this.mode == null) {
                this.mode = lifecyclePhase == null ? "NORMAL" : (lifecyclePhase.contains("test") ? "TEST" : "NORMAL");
            }
            LaunchMode launchMode = LaunchMode.valueOf((String)this.mode);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Bootstrapping Quarkus application in mode " + launchMode));
            }
            if (!((prevConfigExists = Files.exists(compareFile = this.recordedBuildConfigFile == null ? this.recordedBuildConfigDirectory.toPath().resolve("quarkus-" + launchMode.getDefaultProfile() + "-config-dump") : (this.recordedBuildConfigFile.isAbsolute() ? this.recordedBuildConfigFile.toPath() : this.recordedBuildConfigDirectory.toPath().resolve(this.recordedBuildConfigFile.toPath())), new LinkOption[0])) || this.dumpCurrentWhenRecordedUnavailable || this.dumpDependencies)) {
                this.getLog().info((CharSequence)("Config dump from the previous build does not exist at " + compareFile));
                return;
            }
            CuratedApplication curatedApplication = null;
            QuarkusClassLoader deploymentClassLoader = null;
            ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
            boolean clearNativeEnabledSystemProperty = this.setNativeEnabledIfNativeProfileEnabled();
            try {
                curatedApplication = this.bootstrapApplication(launchMode);
                if (prevConfigExists || this.dumpCurrentWhenRecordedUnavailable) {
                    Path targetFile = this.getOutputFile(this.outputFile, launchMode.getDefaultProfile(), "-config-check");
                    Properties compareProps = new Properties();
                    if (prevConfigExists) {
                        try (BufferedReader reader = Files.newBufferedReader(compareFile);){
                            compareProps.load(reader);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to read " + compareFile, e);
                        }
                    }
                    deploymentClassLoader = curatedApplication.createDeploymentClassLoader();
                    Thread.currentThread().setContextClassLoader((ClassLoader)deploymentClassLoader);
                    Class codeGenerator = deploymentClassLoader.loadClass("io.quarkus.deployment.CodeGenerator");
                    Method dumpConfig = codeGenerator.getMethod("dumpCurrentConfigValues", ApplicationModel.class, String.class, Properties.class, QuarkusClassLoader.class, Properties.class, Path.class);
                    dumpConfig.invoke(null, curatedApplication.getApplicationModel(), launchMode.name(), this.getBuildSystemProperties(true), deploymentClassLoader, compareProps, targetFile);
                }
                if (!this.dumpDependencies) break block30;
                ArrayList<Path> deps = new ArrayList<Path>();
                for (ResolvedDependency d : curatedApplication.getApplicationModel().getDependencies(8)) {
                    for (Path resolvedPath : d.getResolvedPaths()) {
                        deps.add(resolvedPath.toAbsolutePath());
                    }
                }
                Collections.sort(deps);
                Path targetFile = this.getOutputFile(this.dependenciesFile, launchMode.getDefaultProfile(), "-dependencies.txt");
                Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(targetFile, new OpenOption[0]);){
                    for (Path dep : deps) {
                        writer.write(dep.toString());
                        writer.newLine();
                    }
                }
            }
            catch (Exception any) {
                throw new MojoExecutionException("Failed to bootstrap Quarkus application", any);
            }
            finally {
                if (clearNativeEnabledSystemProperty) {
                    System.clearProperty("quarkus.native.enabled");
                }
                Thread.currentThread().setContextClassLoader(originalCl);
                if (deploymentClassLoader != null) {
                    deploymentClassLoader.close();
                }
            }
        }
    }

    private Path getOutputFile(File outputFile, String profile, String fileNameSuffix) {
        if (outputFile == null) {
            return this.outputDirectory.toPath().resolve("quarkus-" + profile + fileNameSuffix);
        }
        if (outputFile.isAbsolute()) {
            return outputFile.toPath();
        }
        return this.outputDirectory.toPath().resolve(outputFile.toPath());
    }

    private static void updateChecksum(Checksum checksum, Iterable<Path> pc) throws IOException {
        for (Path path : TrackConfigChangesMojo.sort(pc)) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                DirectoryStream<Path> stream = Files.newDirectoryStream(path);
                try {
                    TrackConfigChangesMojo.updateChecksum(checksum, stream);
                    continue;
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                    continue;
                }
            }
            checksum.update(Files.readAllBytes(path));
        }
    }

    private static Iterable<Path> sort(Iterable<Path> original) {
        Iterator<Path> i = original.iterator();
        if (!i.hasNext()) {
            return List.of();
        }
        Path o = i.next();
        if (!i.hasNext()) {
            return List.of(o);
        }
        ArrayList<Path> sorted = new ArrayList<Path>();
        sorted.add(o);
        while (i.hasNext()) {
            sorted.add(i.next());
        }
        Collections.sort(sorted);
        return sorted;
    }
}

