/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.service.binding.runtime;

import io.quarkus.kubernetes.service.binding.runtime.KubernetesServiceBindingConfig;
import io.quarkus.kubernetes.service.binding.runtime.KubernetesServiceBindingConfigSourceProvider;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Collections;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.logging.Logger;

@Recorder
public class KubernetesServiceBindingRecorder {
    private static final Logger log = Logger.getLogger(KubernetesServiceBindingRecorder.class);
    final KubernetesServiceBindingConfig kubernetesServiceBindingConfig;

    public KubernetesServiceBindingRecorder(KubernetesServiceBindingConfig kubernetesServiceBindingConfig) {
        this.kubernetesServiceBindingConfig = kubernetesServiceBindingConfig;
    }

    public RuntimeValue<ConfigSourceProvider> configSources() {
        if (!this.kubernetesServiceBindingConfig.enabled) {
            log.debug((Object)"No attempt will be made to bind configuration based on Kubernetes ServiceBinding because the feature was not enabled.");
            return this.emptyRuntimeValue();
        }
        if (!this.kubernetesServiceBindingConfig.root.isPresent()) {
            log.debug((Object)"No attempt will be made to bind configuration based on Kubernetes Service Binding because the binding root was not specified.");
            return this.emptyRuntimeValue();
        }
        return new RuntimeValue((Object)new KubernetesServiceBindingConfigSourceProvider(this.kubernetesServiceBindingConfig.root.get()));
    }

    private RuntimeValue<ConfigSourceProvider> emptyRuntimeValue() {
        return new RuntimeValue((Object)new EmptyConfigSourceProvider());
    }

    private static class EmptyConfigSourceProvider
    implements ConfigSourceProvider {
        private EmptyConfigSourceProvider() {
        }

        public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
            return Collections.emptyList();
        }
    }
}

