/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.service.binding.runtime;

import io.quarkus.kubernetes.service.binding.runtime.ServiceBinding;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConfigSource;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.logging.Logger;

public class KubernetesServiceBindingConfigSourceProvider
implements ConfigSourceProvider {
    private static final Logger log = Logger.getLogger(KubernetesServiceBindingConfigSourceProvider.class);
    private final List<ServiceBinding> serviceBindings;
    private final List<ServiceBindingConverter> serviceBindingConverters;

    public KubernetesServiceBindingConfigSourceProvider(String bindingRoot) {
        this(bindingRoot, KubernetesServiceBindingConfigSourceProvider.determineConverters());
    }

    KubernetesServiceBindingConfigSourceProvider(String bindingRoot, List<ServiceBindingConverter> serviceBindingConverters) {
        this.serviceBindingConverters = serviceBindingConverters;
        Path p = Paths.get(bindingRoot, new String[0]);
        if (!Files.exists(p, new LinkOption[0])) {
            log.warn((Object)("Service Binding root '" + p.toAbsolutePath() + "' does not exist"));
            this.serviceBindings = Collections.emptyList();
            return;
        }
        if (!Files.isDirectory(p, new LinkOption[0])) {
            throw new IllegalArgumentException("Service Binding root '" + p + "' is not a directory");
        }
        File[] files = p.toFile().listFiles();
        if (files == null) {
            log.warn((Object)("Service Binding root '" + p.toAbsolutePath() + "' does not contain any sub-directories"));
            this.serviceBindings = Collections.emptyList();
        } else {
            log.debug((Object)("Found " + files.length + " potential Service Binding directories"));
            this.serviceBindings = new ArrayList<ServiceBinding>(files.length);
            for (File f : files) {
                ServiceBinding sb = new ServiceBinding(f.toPath());
                this.serviceBindings.add(sb);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Directory '%s' contains %d %s and will be used as Service Binding %s", f.toPath().toAbsolutePath(), sb.getProperties().size(), sb.getProperties().size() == 1 ? "property" : "properties", sb));
            }
            this.serviceBindings.sort(new Comparator<ServiceBinding>(){

                @Override
                public int compare(ServiceBinding o1, ServiceBinding o2) {
                    if (!o1.getName().equals(o2.getName())) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    return o1.getProvider().compareTo(o2.getProvider());
                }
            });
        }
    }

    private static List<ServiceBindingConverter> determineConverters() {
        ArrayList<ServiceBindingConverter> result = new ArrayList<ServiceBindingConverter>();
        ServiceLoader<ServiceBindingConverter> loader = ServiceLoader.load(ServiceBindingConverter.class, Thread.currentThread().getContextClassLoader());
        for (ServiceBindingConverter c : loader) {
            result.add(c);
        }
        return result;
    }

    public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        if (this.serviceBindings.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>();
        for (ServiceBindingConverter converter : this.serviceBindingConverters) {
            Optional<ServiceBindingConfigSource> optional = converter.convert(this.serviceBindings);
            if (!optional.isPresent()) continue;
            result.add((ConfigSource)optional.get());
        }
        for (ServiceBinding serviceBinding : this.serviceBindings) {
            Map<String, String> serviceBindingProperties = serviceBinding.getProperties();
            HashMap<String, String> rawConfigSourceProperties = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : serviceBindingProperties.entrySet()) {
                rawConfigSourceProperties.put("quarkus.service-binding." + serviceBinding.getName() + "." + entry.getKey(), entry.getValue());
            }
            result.add((ConfigSource)new ServiceBindingConfigSource("service-binding-" + serviceBinding.getName() + "-raw", rawConfigSourceProperties));
        }
        return result;
    }
}

