/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.commons.classloading.ClassLoaderHelper;
import io.quarkus.deployment.dev.testing.CurrentTestApplication;
import io.quarkus.deployment.dev.testing.TestConfig;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.RestorableSystemProperties;
import io.quarkus.test.common.TestClassIndexer;
import io.quarkus.test.junit.AbstractQuarkusTestWithContextExtension;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestBuildChainFunction;
import io.quarkus.test.junit.TestProfile;
import io.smallrye.config.SmallRyeConfig;
import jakarta.enterprise.inject.Alternative;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.Index;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

public class AbstractJvmQuarkusTestExtension
extends AbstractQuarkusTestWithContextExtension
implements ExecutionCondition {
    protected static final String TEST_LOCATION = "test-location";
    protected static final String TEST_CLASS = "test-class";
    protected static final String TEST_PROFILE = "test-profile";
    protected ClassLoader originalCl;
    protected static Class<? extends QuarkusTestProfile> quarkusTestProfile;
    protected static final Deque<Class<?>> currentTestClassStack;
    protected static Class<?> currentJUnitTestClass;

    protected PrepareResult createAugmentor(ExtensionContext context, Class<? extends QuarkusTestProfile> profile, Collection<Runnable> shutdownTasks) throws Exception {
        CuratedApplication curatedApplication;
        Path testClassLocation;
        Class requiredTestClass;
        PathList.Builder rootBuilder = PathList.builder();
        Consumer<Path> addToBuilderIfConditionMet = path -> {
            if (path != null && Files.exists(path, new LinkOption[0]) && !rootBuilder.contains(path)) {
                rootBuilder.add(path);
            }
        };
        currentJUnitTestClass = requiredTestClass = context.getRequiredTestClass();
        Path projectRoot = Paths.get("", new String[0]).normalize().toAbsolutePath();
        ApplicationModel gradleAppModel = this.getGradleAppModelForIDE(projectRoot);
        if (gradleAppModel != null && gradleAppModel.getApplicationModule() != null) {
            WorkspaceModule module = gradleAppModel.getApplicationModule();
            String[] testClassFileName = ClassLoaderHelper.fromClassNameToResourceName((String)requiredTestClass.getName());
            Path testClassesDir = null;
            for (Object classifier : module.getSourceClassifiers()) {
                ArtifactSources sources = module.getSources((String)classifier);
                if (!sources.isOutputAvailable() || !sources.getOutputTree().contains((String)testClassFileName)) continue;
                for (SourceDir src : sources.getSourceDirs()) {
                    addToBuilderIfConditionMet.accept(src.getOutputDir());
                    if (!Files.exists(src.getOutputDir().resolve((String)testClassFileName), new LinkOption[0])) continue;
                    testClassesDir = src.getOutputDir();
                }
                for (SourceDir src : sources.getResourceDirs()) {
                    addToBuilderIfConditionMet.accept(src.getOutputDir());
                }
                for (SourceDir src : module.getMainSources().getSourceDirs()) {
                    addToBuilderIfConditionMet.accept(src.getOutputDir());
                }
                for (SourceDir src : module.getMainSources().getResourceDirs()) {
                    addToBuilderIfConditionMet.accept(src.getOutputDir());
                }
            }
            if (testClassesDir == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("Failed to locate ").append(requiredTestClass.getName()).append(" in ");
                for (String classifier : module.getSourceClassifiers()) {
                    ArtifactSources sources = module.getSources(classifier);
                    if (!sources.isOutputAvailable()) continue;
                    for (SourceDir d : sources.getSourceDirs()) {
                        if (!Files.exists(d.getOutputDir(), new LinkOption[0])) continue;
                        sb.append(System.lineSeparator()).append(d.getOutputDir());
                    }
                }
                throw new RuntimeException(sb.toString());
            }
            testClassLocation = testClassesDir;
        } else {
            Path appClassLocation;
            if (System.getProperty("OUTPUT_SOURCES_DIR") != null) {
                String[] sourceDirectories;
                for (String sourceDirectory : sourceDirectories = System.getProperty("OUTPUT_SOURCES_DIR").split(",")) {
                    Path directory = Paths.get(sourceDirectory, new String[0]);
                    addToBuilderIfConditionMet.accept(directory);
                }
            }
            if (!(appClassLocation = PathTestHelper.getAppClassLocationForTestLocation((Path)(testClassLocation = PathTestHelper.getTestClassesLocation((Class)requiredTestClass)))).equals(testClassLocation)) {
                addToBuilderIfConditionMet.accept(testClassLocation);
                Path testResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)testClassLocation, (String)"test");
                addToBuilderIfConditionMet.accept(testResourcesLocation);
            }
            addToBuilderIfConditionMet.accept(appClassLocation);
            Path appResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)appClassLocation, (String)"main");
            addToBuilderIfConditionMet.accept(appResourcesLocation);
        }
        this.originalCl = Thread.currentThread().getContextClassLoader();
        System.clearProperty("test.url");
        HashMap<String, String> additional = new HashMap<String, String>();
        QuarkusTestProfile profileInstance = null;
        if (profile != null) {
            profileInstance = profile.getConstructor(new Class[0]).newInstance(new Object[0]);
            additional.putAll(profileInstance.getConfigOverrides());
            if (!profileInstance.getEnabledAlternatives().isEmpty()) {
                additional.put("quarkus.arc.selected-alternatives", profileInstance.getEnabledAlternatives().stream().peek(c -> {
                    if (!c.isAnnotationPresent(Alternative.class)) {
                        throw new RuntimeException("Enabled alternative " + String.valueOf(c) + " is not annotated with @Alternative");
                    }
                }).map(Class::getName).collect(Collectors.joining(",")));
            }
            if (profileInstance.disableApplicationLifecycleObservers()) {
                additional.put("quarkus.arc.test.disable-application-lifecycle-observers", "true");
            }
            if (profileInstance.getConfigProfile() != null) {
                additional.put(LaunchMode.TEST.getProfileKey(), profileInstance.getConfigProfile());
            }
            shutdownTasks.add(() -> ((RestorableSystemProperties)RestorableSystemProperties.setProperties(additional, (String[])new String[0])).close());
        }
        if (CurrentTestApplication.curatedApplication != null) {
            curatedApplication = CurrentTestApplication.curatedApplication;
        } else {
            curatedApplication = QuarkusBootstrap.builder().setBaseName(context.getDisplayName() + " (QuarkusTest)").setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.TEST).setTest(true).setTargetDirectory(PathTestHelper.getProjectBuildDir((Path)projectRoot, (Path)testClassLocation)).setProjectRoot(projectRoot).setApplicationRoot((PathCollection)rootBuilder.build()).build().bootstrap();
            shutdownTasks.add(() -> ((CuratedApplication)curatedApplication).close());
        }
        if (curatedApplication.getApplicationModel().getRuntimeDependencies().isEmpty()) {
            throw new RuntimeException("The tests were run against a directory that does not contain a Quarkus project. Please ensure that the test is configured to use the proper working directory.");
        }
        Index testClassesIndex = TestClassIndexer.indexTestClasses((Path)testClassLocation);
        TestClassIndexer.writeIndex((Index)testClassesIndex, (Path)testClassLocation, (Class)requiredTestClass);
        Timing.staticInitStarted((ClassLoader)curatedApplication.getOrCreateBaseRuntimeClassLoader(), (boolean)curatedApplication.getQuarkusBootstrap().isAuxiliaryApplication());
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(TEST_LOCATION, testClassLocation);
        props.put(TEST_CLASS, requiredTestClass);
        if (profile != null) {
            props.put(TEST_PROFILE, profile.getName());
        }
        quarkusTestProfile = profile;
        return new PrepareResult(curatedApplication.createAugmentor(TestBuildChainFunction.class.getName(), props), profileInstance, curatedApplication, testClassLocation);
    }

    private ApplicationModel getGradleAppModelForIDE(Path projectRoot) throws IOException, AppModelResolverException {
        return System.getProperty("quarkus-internal-test.serialized-app-model.path") == null ? BuildToolHelper.enableGradleAppModelForTest((Path)projectRoot) : null;
    }

    protected Class<? extends QuarkusTestProfile> getQuarkusTestProfile(ExtensionContext extensionContext) {
        Class<? extends QuarkusTestProfile> testProfile = this.findTestProfileAnnotation(extensionContext.getRequiredTestClass());
        if (testProfile != null) {
            return testProfile;
        }
        if (extensionContext.getRequiredTestClass().isAnnotationPresent(Nested.class)) {
            ExtensionContext currentExtensionContext;
            testProfile = this.findTestProfileAnnotation(extensionContext.getRequiredTestClass().getEnclosingClass());
            if (testProfile != null) {
                return testProfile;
            }
            Optional parentContext = extensionContext.getParent();
            while (parentContext.isPresent() && !(currentExtensionContext = (ExtensionContext)parentContext.get()).getTestClass().isEmpty()) {
                testProfile = this.findTestProfileAnnotation((Class)currentExtensionContext.getTestClass().get());
                if (testProfile != null) {
                    return testProfile;
                }
                parentContext = currentExtensionContext.getParent();
            }
        }
        return null;
    }

    private Class<? extends QuarkusTestProfile> findTestProfileAnnotation(Class<?> clazz) {
        for (Class<?> testClass = clazz; testClass != null; testClass = testClass.getEnclosingClass()) {
            TestProfile annotation = testClass.getAnnotation(TestProfile.class);
            if (annotation == null) continue;
            return annotation.value();
        }
        return null;
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        QuarkusTestProfile profileInstance;
        if (!context.getTestClass().isPresent()) {
            return ConditionEvaluationResult.enabled((String)"No test class specified");
        }
        if (context.getTestInstance().isPresent()) {
            return ConditionEvaluationResult.enabled((String)"Quarkus Test Profile tags only affect classes");
        }
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        TestConfig testConfig = (TestConfig)config.getConfigMapping(TestConfig.class);
        Optional tags = testConfig.profile().tags();
        if (tags.isEmpty() || ((List)tags.get()).isEmpty()) {
            return ConditionEvaluationResult.enabled((String)"No Quarkus Test Profile tags");
        }
        Class<? extends QuarkusTestProfile> testProfile = this.getQuarkusTestProfile(context);
        if (testProfile == null) {
            return ConditionEvaluationResult.disabled((String)("Test '" + String.valueOf(context.getRequiredTestClass()) + "' is not annotated with '@QuarkusTestProfile' but 'quarkus.profile.test.tags' was set"));
        }
        try {
            profileInstance = testProfile.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Set<String> testProfileTags = profileInstance.tags();
        for (String tag : (List)tags.get()) {
            String trimmedTag = tag.trim();
            if (!testProfileTags.contains(trimmedTag)) continue;
            return ConditionEvaluationResult.enabled((String)("Tag '" + trimmedTag + "' is present on '" + String.valueOf(testProfile) + "' which is used on test '" + String.valueOf(context.getRequiredTestClass())));
        }
        return ConditionEvaluationResult.disabled((String)("Test '" + String.valueOf(context.getRequiredTestClass()) + "' disabled because 'quarkus.profile.test.tags' don't match the tags of '" + String.valueOf(testProfile) + "'"));
    }

    static {
        currentTestClassStack = new ArrayDeque();
    }

    protected static class PrepareResult {
        protected final AugmentAction augmentAction;
        protected final QuarkusTestProfile profileInstance;
        protected final CuratedApplication curatedApplication;
        protected final Path testClassLocation;

        public PrepareResult(AugmentAction augmentAction, QuarkusTestProfile profileInstance, CuratedApplication curatedApplication, Path testClassLocation) {
            this.augmentAction = augmentAction;
            this.profileInstance = profileInstance;
            this.curatedApplication = curatedApplication;
            this.testClassLocation = testClassLocation;
        }
    }
}

