/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jsonb;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.yasson.spi.JsonbComponentInstanceCreator;

public class QuarkusJsonbComponentInstanceCreator
implements JsonbComponentInstanceCreator {
    private final Map<Class<?>, Object> components;
    private final List<InstanceHandle<?>> beanHandles = new ArrayList();

    public QuarkusJsonbComponentInstanceCreator() {
        this.components = new ConcurrentHashMap();
    }

    public void close() throws IOException {
        this.beanHandles.forEach(InstanceHandle::close);
        this.beanHandles.clear();
        this.components.clear();
    }

    public <T> T getOrCreateComponent(Class<T> componentClass) {
        return (T)this.components.computeIfAbsent(componentClass, c -> {
            ArcContainer container = Arc.container();
            if (container == null) {
                return this.fallbackCreate(componentClass);
            }
            InstanceHandle beanHandle = container.instance(componentClass, new Annotation[0]);
            if (beanHandle.isAvailable()) {
                this.beanHandles.add(beanHandle);
                return beanHandle.get();
            }
            return this.fallbackCreate(componentClass);
        });
    }

    private <T> Object fallbackCreate(Class<T> componentClass) {
        try {
            return componentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Cannot instantiate JSON-B component: " + String.valueOf(componentClass), e);
        }
    }
}

