/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.orm.elasticsearch.runtime.devconsole;

import io.quarkus.arc.Arc;
import io.quarkus.hibernate.orm.PersistenceUnit;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.mapper.orm.entity.SearchIndexedEntity;
import org.hibernate.search.mapper.orm.mapping.SearchMapping;

public class HibernateSearchSupplier
implements Supplier<IndexedPersistenceUnits> {
    private final Set<String> activePersistenceUnitNames;

    HibernateSearchSupplier(Set<String> activePersistenceUnitNames) {
        this.activePersistenceUnitNames = activePersistenceUnitNames;
    }

    @Override
    public IndexedPersistenceUnits get() {
        Map<String, SearchMapping> mappings = HibernateSearchSupplier.searchMapping(this.activePersistenceUnitNames);
        if (mappings.isEmpty()) {
            return new IndexedPersistenceUnits();
        }
        return mappings.entrySet().stream().map(mapping -> new IndexedPersistenceUnit((String)mapping.getKey(), ((SearchMapping)mapping.getValue()).allIndexedEntities().stream().map(DevUiIndexedEntity::new).sorted().collect(Collectors.toList()))).collect(Collector.of(IndexedPersistenceUnits::new, IndexedPersistenceUnits::add, (left, right) -> {
            left.addAll((IndexedPersistenceUnits)right);
            return left;
        }, new Collector.Characteristics[0]));
    }

    public static Map<String, SearchMapping> searchMapping(Set<String> persistenceUnitNames) {
        return Arrays.stream(HibernateSearchSupplier.getPersistenceUnitQualifiers(persistenceUnitNames)).map(qualifier -> (SearchMapping)Arc.container().select(SearchMapping.class, new Annotation[]{qualifier}).get()).collect(Collectors.toMap(HibernateSearchSupplier::getPersistenceUnitName, mapping -> mapping));
    }

    private static Annotation[] getPersistenceUnitQualifiers(Set<String> persistenceUnitNames) {
        return (Annotation[])persistenceUnitNames.stream().map(PersistenceUnit.PersistenceUnitLiteral::new).toArray(Annotation[]::new);
    }

    private static String getPersistenceUnitName(SearchMapping searchMapping) {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)searchMapping.toOrmSessionFactory().unwrap(SessionFactoryImplementor.class);
        String name = sessionFactory.getName();
        if (name != null) {
            return name;
        }
        Object persistenceUnitName = sessionFactory.getProperties().get("hibernate.persistenceUnitName");
        if (persistenceUnitName != null) {
            return persistenceUnitName.toString();
        }
        return "<default>";
    }

    public static class DevUiIndexedEntity
    implements Comparable<DevUiIndexedEntity> {
        public final String jpaName;
        public final String javaClass;

        DevUiIndexedEntity(SearchIndexedEntity<?> searchIndexedEntity) {
            this.jpaName = searchIndexedEntity.jpaName();
            this.javaClass = searchIndexedEntity.javaClass().getName();
        }

        @Override
        public int compareTo(DevUiIndexedEntity o) {
            return this.jpaName.compareTo(o.jpaName);
        }
    }

    static class IndexedPersistenceUnit
    implements Comparable<IndexedPersistenceUnit> {
        public final String persistenceUnitName;
        public final List<DevUiIndexedEntity> indexedEntities;

        public IndexedPersistenceUnit(String persistenceUnitName, List<DevUiIndexedEntity> indexedEntities) {
            this.persistenceUnitName = persistenceUnitName;
            this.indexedEntities = indexedEntities;
        }

        @Override
        public int compareTo(IndexedPersistenceUnit o) {
            return this.persistenceUnitName.compareTo(o.persistenceUnitName);
        }
    }

    static class PersistenceUnitComparator
    implements Comparator<IndexedPersistenceUnit> {
        Comparator<String> persistenceUnitNameComparator = new PersistenceUnitUtil.PersistenceUnitNameComparator();

        PersistenceUnitComparator() {
        }

        @Override
        public int compare(IndexedPersistenceUnit o1, IndexedPersistenceUnit o2) {
            return this.persistenceUnitNameComparator.compare(o1.persistenceUnitName, o2.persistenceUnitName);
        }
    }

    static class IndexedPersistenceUnits {
        private final Set<IndexedPersistenceUnit> persistenceUnits = new TreeSet<IndexedPersistenceUnit>(new PersistenceUnitComparator());

        IndexedPersistenceUnits() {
        }

        public Set<IndexedPersistenceUnit> getPersistenceUnits() {
            return this.persistenceUnits;
        }

        public void add(IndexedPersistenceUnit indexedPersistenceUnit) {
            this.persistenceUnits.add(indexedPersistenceUnit);
        }

        public void addAll(IndexedPersistenceUnits right) {
            this.persistenceUnits.addAll(right.persistenceUnits);
        }

        public int getNumberOfIndexedEntities() {
            return this.persistenceUnits.stream().mapToInt(pu -> pu.indexedEntities.size()).sum();
        }
    }
}

