/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.customized;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.jackson.ObjectMapperCustomizer;
import io.quarkus.jsonb.JsonbConfigCustomizer;
import jakarta.enterprise.inject.Instance;
import jakarta.json.bind.Jsonb;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.microprofile.config.ConfigProvider;

public interface JsonFormatterCustomizationCheck
extends Function<ArcContainer, List<String>> {
    @Override
    public List<String> apply(ArcContainer var1);

    public static JsonFormatterCustomizationCheck jsonFormatterCustomizationCheckSupplier(boolean required, boolean isJackson) {
        if (!required) {
            return new NotModifiedJsonFormatterCustomizationCheck();
        }
        if (isJackson) {
            return new JacksonJsonFormatterCustomizationCheck();
        }
        return new JsonbJsonFormatterCustomizationCheck();
    }

    public static class NotModifiedJsonFormatterCustomizationCheck
    implements JsonFormatterCustomizationCheck {
        @Override
        public List<String> apply(ArcContainer container) {
            return List.of();
        }
    }

    public static class JacksonJsonFormatterCustomizationCheck
    implements JsonFormatterCustomizationCheck {
        @Override
        public List<String> apply(ArcContainer container) {
            InjectableInstance customizers;
            InstanceHandle objectMapperInstance = container.instance(ObjectMapper.class, new Annotation[0]);
            if (!objectMapperInstance.isAvailable()) {
                return List.of();
            }
            ArrayList<String> causes = new ArrayList<String>();
            if (!objectMapperInstance.getBean().isDefaultBean()) {
                causes.add("ObjectMapper instance is not the Quarkus default one. A bean producer was likely used to replace it.");
            }
            if (!(customizers = container.select(ObjectMapperCustomizer.class, new Annotation[0])).isUnsatisfied()) {
                Set<String> allowedCustomizers = Set.of("io.quarkus.jackson.customizer.RegisterSerializersAndDeserializersCustomizer", "io.quarkus.jackson.runtime.ConfigurationCustomizer", "io.quarkus.jackson.runtime.VertxHybridPoolObjectMapperCustomizer");
                for (Instance.Handle handle : customizers.handles()) {
                    if (allowedCustomizers.contains(handle.getBean().getBeanClass().getName())) continue;
                    causes.add("Detected '" + handle.getBean().getBeanClass().getName() + "' bean registered. It may have customized the ObjectMapper in a way not compatible with the default one. Review the customizer and apply customizations you need for the database serialization/deserialization of JSON fields to your custom mapper.");
                }
            }
            Set<String> acceptableConfigs = Set.of("quarkus.jackson.fail-on-unknown-properties", "quarkus.jackson.fail-on-empty-beans");
            Map<String, String> expectedDefaults = Map.of("quarkus.jackson.write-dates-as-timestamps", "true", "quarkus.jackson.write-durations-as-timestamps", "true", "quarkus.jackson.accept-case-insensitive-enums", "false", "quarkus.jackson.timezone", "UTC");
            Map<String, String> actionsToTake = Map.of("quarkus.jackson.write-dates-as-timestamps", "disable the corresponding serialization feature, i.e. 'mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)'", "quarkus.jackson.write-durations-as-timestamps", "disable the corresponding serialization feature, i.e. 'mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)'", "quarkus.jackson.accept-case-insensitive-enums", "enable the corresponding mapper feature, i.e. 'mapper.enable(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS)'", "quarkus.jackson.timezone", "configure the mapper timezone, i.e. 'mapper.setTimeZone(yourTimezone)'");
            for (String propertyName : ConfigProvider.getConfig().getPropertyNames()) {
                String okValue;
                if (!propertyName.startsWith("quarkus.jackson.") || acceptableConfigs.contains(propertyName) || (okValue = expectedDefaults.get(propertyName)) == null || okValue.equalsIgnoreCase(ConfigProvider.getConfig().getConfigValue(propertyName).getRawValue())) continue;
                causes.add("Detected '" + propertyName + "' property set to '" + ConfigProvider.getConfig().getConfigValue(propertyName).getRawValue() + "'. To make your custom ObjectMapper compatible with this configuration: " + actionsToTake.get(propertyName) + ".");
            }
            return causes;
        }
    }

    public static class JsonbJsonFormatterCustomizationCheck
    implements JsonFormatterCustomizationCheck {
        @Override
        public List<String> apply(ArcContainer container) {
            InstanceHandle jsonbInstance = container.instance(Jsonb.class, new Annotation[0]);
            if (!jsonbInstance.isAvailable()) {
                return List.of();
            }
            ArrayList<String> causes = new ArrayList<String>();
            if (!jsonbInstance.getBean().isDefaultBean()) {
                causes.add("Jsonb instance is not the Quarkus default one. A bean producer was likely used to replace it.");
            }
            InjectableInstance customizers = container.select(JsonbConfigCustomizer.class, new Annotation[0]);
            Set<String> allowedCustomizers = Set.of("io.quarkus.jsonb.customizer.RegisterSerializersAndDeserializersCustomizer");
            for (Instance.Handle handle : customizers.handles()) {
                if (allowedCustomizers.contains(handle.getBean().getBeanClass().getName())) continue;
                causes.add("Detected '" + handle.getBean().getBeanClass().getName() + "' bean registered. It may have customized the Jsonb in a way not compatible with the default one. Review the customizer and apply customizations you need for the database serialization/deserialization of JSON fields to your custom Jsonb.");
            }
            return causes;
        }
    }
}

