/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.welcome;

import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.deployment.IsLocalDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.devui.deployment.ExtensionsBuildItem;
import io.quarkus.devui.deployment.InternalPageBuildItem;
import io.quarkus.devui.deployment.extension.Extension;
import io.quarkus.devui.deployment.welcome.WelcomeData;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class WelcomeProcessor {
    @BuildStep(onlyIf={IsLocalDevelopment.class})
    InternalPageBuildItem createWelcomePages(CurateOutcomeBuildItem curateOutcomeBuildItem, ExtensionsBuildItem extensionsBuildItem) {
        InternalPageBuildItem welcomePageBuildItem = new InternalPageBuildItem("Welcome", 99999);
        welcomePageBuildItem.addBuildTimeData("welcomeData", this.createWelcomeData(curateOutcomeBuildItem, extensionsBuildItem), "Contains high level information about the Quarkus application, including the configFile, resourcesDir, sourceDir and selectedExtensions");
        welcomePageBuildItem.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().namespace("devui-welcome")).title("Welcome")).icon("font-awesome-brands:redhat")).componentLink("qwc-welcome.js").excludeFromMenu());
        return welcomePageBuildItem;
    }

    private WelcomeData createWelcomeData(CurateOutcomeBuildItem curateOutcomeBuildItem, ExtensionsBuildItem extensionsBuildItem) {
        WorkspaceModule workspaceModule = curateOutcomeBuildItem.getApplicationModel().getApplicationModule();
        WelcomeData welcomeData = new WelcomeData();
        welcomeData.configFile = this.getConfigFile(workspaceModule);
        welcomeData.sourceDir = this.getSourceDir(workspaceModule);
        welcomeData.resourcesDir = this.getResourcesDir(workspaceModule);
        List<Extension> selectedExtensions = this.getSelectedExtensions(workspaceModule, extensionsBuildItem);
        for (Extension extension : selectedExtensions) {
            if (extension == null || extension.getName() == null) continue;
            welcomeData.addSelectedExtension(extension.getName(), extension.getDescription(), extension.getGuide());
        }
        return welcomeData;
    }

    private String getConfigFile(WorkspaceModule workspaceModule) {
        File moduleDir;
        if (workspaceModule != null && (moduleDir = workspaceModule.getModuleDir()) != null) {
            String root = moduleDir.toPath().toString();
            Collection resourcesDirs = workspaceModule.getMainSources().getResourceDirs();
            if (resourcesDirs != null && !resourcesDirs.isEmpty()) {
                Path resourceDirs = ((SourceDir)resourcesDirs.iterator().next()).getDir();
                Path propertiesFile = resourceDirs.resolve("application.properties");
                if (Files.exists(propertiesFile, new LinkOption[0])) {
                    return propertiesFile.toString().replace("\\", "/").substring(root.length() + 1);
                }
                Path propertiesYaml = resourceDirs.resolve("application.yaml");
                if (Files.exists(propertiesYaml, new LinkOption[0])) {
                    return propertiesYaml.toString().replace("\\", "/").substring(root.length() + 1);
                }
            }
        }
        return null;
    }

    private String getSourceDir(WorkspaceModule workspaceModule) {
        File moduleDir;
        if (workspaceModule != null && (moduleDir = workspaceModule.getModuleDir()) != null) {
            String root = moduleDir.toPath().toString();
            Collection sourceDirs = workspaceModule.getMainSources().getSourceDirs();
            if (sourceDirs != null && !sourceDirs.isEmpty()) {
                String sourceDir = ((SourceDir)sourceDirs.iterator().next()).getDir().toString().replace("\\", "/");
                return sourceDir.substring(root.length() + 1);
            }
        }
        return null;
    }

    private String getResourcesDir(WorkspaceModule workspaceModule) {
        File moduleDir;
        if (workspaceModule != null && (moduleDir = workspaceModule.getModuleDir()) != null) {
            String root = moduleDir.toPath().toString();
            Collection resourcesDirs = workspaceModule.getMainSources().getResourceDirs();
            if (resourcesDirs != null && !resourcesDirs.isEmpty()) {
                String resourceDirs = ((SourceDir)resourcesDirs.iterator().next()).getDir().toString().replace("\\", "/");
                return resourceDirs.substring(root.length() + 1);
            }
        }
        return null;
    }

    private List<Extension> getSelectedExtensions(WorkspaceModule workspaceModule, ExtensionsBuildItem extensionsBuildItem) {
        Map<String, Extension> extensionMap = this.getExtensionMap(extensionsBuildItem);
        if (workspaceModule != null) {
            List<Extension> selectedDependency = workspaceModule.getDirectDependencies().stream().filter(dependency -> dependency.isJar() && (dependency.getScope() == null || !dependency.getScope().equals("test")) && !dependency.getGroupId().startsWith("org.mvnpm") && !dependency.getGroupId().startsWith("org.webjars")).map(t -> {
                String key = t.getGroupId() + ":" + t.getArtifactId();
                return (Extension)extensionMap.get(key);
            }).collect(Collectors.toList());
            return selectedDependency;
        }
        return List.of();
    }

    private Map<String, Extension> getExtensionMap(ExtensionsBuildItem extensionsBuildItem) {
        HashMap<String, Extension> all = new HashMap<String, Extension>();
        extensionsBuildItem.getActiveExtensions().forEach(t -> {
            String[] gav = t.getArtifact().split(":");
            all.put(gav[0] + ":" + gav[1], (Extension)t);
        });
        extensionsBuildItem.getInactiveExtensions().forEach(t -> {
            String[] gav = t.getArtifact().split(":");
            all.put(gav[0] + ":" + gav[1], (Extension)t);
        });
        return all;
    }
}

