/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;

@ConfigRoot
@ConfigMapping(prefix="quarkus.dev-ui")
public interface DevUIConfig {
    @WithDefault(value="50")
    public int historySize();

    @WithDefault(value="false")
    public boolean showJsonRpcLog();

    @WithDefault(value="quarkus")
    public BaseTheme baseTheme();

    public Optional<List<String>> hosts();

    public Optional<String> contextRoot();

    public Workspace workspace();

    public Cors cors();

    @WithDefault(value="true")
    public boolean allowExtensionManagement();

    public Optional<Theme> theme();

    public static enum BaseTheme {
        quarkus,
        red,
        blue;

    }

    @ConfigGroup
    public static interface ThemeMode {
        public Optional<String> baseColor();

        public Optional<String> contrast();

        public Optional<String> primaryColor();

        public Optional<String> primaryTextColor();

        public Optional<String> primaryContrastColor();

        public Optional<String> errorColor();

        public Optional<String> errorTextColor();

        public Optional<String> errorContrastColor();

        public Optional<String> warningColor();

        public Optional<String> warningTextColor();

        public Optional<String> warningContrastColor();

        public Optional<String> successColor();

        public Optional<String> successTextColor();

        public Optional<String> successContrastColor();

        public Optional<String> headerTextColor();

        public Optional<String> bodyTextColor();

        public Optional<String> secondaryTextColor();

        public Optional<String> tertiaryTextColor();

        public Optional<String> disabledTextColor();

        public Optional<String> contrast5pct();

        public Optional<String> contrast10pct();

        public Optional<String> contrast15pct();

        public Optional<String> contrast20pct();

        public Optional<String> contrast25pct();

        public Optional<String> contrast30pct();

        public Optional<String> contrast35pct();

        public Optional<String> contrast40pct();

        public Optional<String> contrast45pct();

        public Optional<String> contrast50pct();

        public Optional<String> contrast55pct();

        public Optional<String> contrast60pct();

        public Optional<String> contrast65pct();

        public Optional<String> contrast70pct();

        public Optional<String> contrast75pct();

        public Optional<String> contrast80pct();

        public Optional<String> contrast85pct();

        public Optional<String> contrast90pct();
    }

    @ConfigGroup
    public static interface Theme {
        public Optional<ThemeMode> dark();

        public Optional<ThemeMode> light();
    }

    @ConfigGroup
    public static interface Cors {
        @WithDefault(value="true")
        public boolean enabled();
    }

    @ConfigGroup
    public static interface Workspace {
        public Optional<List<String>> ignoreFolders();

        public Optional<List<Pattern>> ignoreFiles();
    }
}

