/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry;

import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.Platform;
import io.quarkus.registry.catalog.PlatformCatalog;
import io.quarkus.registry.client.RegistryClient;
import io.quarkus.registry.config.RegistryConfig;
import io.quarkus.util.GlobUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.regex.Pattern;

class RegistryExtensionResolver {
    public static final int VERSION_NOT_RECOGNIZED = -1;
    public static final int VERSION_NOT_CONFIGURED = 0;
    public static final int VERSION_RECOGNIZED = 1;
    public static final int VERSION_EXCLUSIVE_PROVIDER = 2;
    private static final String DASH_SUPPORT = "-support";
    private final RegistryConfig config;
    private final RegistryClient extensionResolver;
    private final int index;
    private final Pattern recognizedQuarkusVersions;
    private final Collection<String> recognizedGroupIds;
    private final String offeringSupportKey;

    private static String getConfiguredOfferingOrNull(RegistryConfig config) {
        Object offering = config.getExtra().get("offering");
        if (offering == null) {
            return null;
        }
        if (!(offering instanceof String)) {
            throw new IllegalArgumentException("Expected a string value for option offering but got " + String.valueOf(offering) + " of type " + offering.getClass().getName());
        }
        String str = offering.toString();
        return str.isBlank() ? null : str;
    }

    RegistryExtensionResolver(RegistryClient extensionResolver, MessageWriter log, int index) throws RegistryResolutionException {
        this.extensionResolver = Objects.requireNonNull(extensionResolver, "Registry extension resolver is null");
        this.config = extensionResolver.resolveRegistryConfig();
        this.index = index;
        String versionExpr = this.config.getQuarkusVersions() == null ? null : this.config.getQuarkusVersions().getRecognizedVersionsExpression();
        this.recognizedQuarkusVersions = versionExpr == null ? null : Pattern.compile(GlobUtil.toRegexPattern((String)versionExpr));
        this.recognizedGroupIds = this.config.getQuarkusVersions() == null ? Collections.emptyList() : this.config.getQuarkusVersions().getRecognizedGroupIds();
        String offering = RegistryExtensionResolver.getConfiguredOfferingOrNull(this.config);
        if (offering != null) {
            log.info("Registry " + this.config.getId() + " is limited to offerings " + offering);
            this.offeringSupportKey = offering + DASH_SUPPORT;
        } else {
            this.offeringSupportKey = null;
        }
    }

    String getId() {
        return this.config.getId();
    }

    int getIndex() {
        return this.index;
    }

    int checkQuarkusVersion(String quarkusVersion) {
        if (this.recognizedQuarkusVersions == null) {
            return 0;
        }
        if (quarkusVersion == null) {
            throw new IllegalArgumentException();
        }
        if (!this.recognizedQuarkusVersions.matcher(quarkusVersion).matches()) {
            return -1;
        }
        return this.config.getQuarkusVersions().isExclusiveProvider() ? 2 : 1;
    }

    boolean isExclusiveProviderOf(String quarkusVersion) {
        return this.checkQuarkusVersion(quarkusVersion) == 2;
    }

    boolean isAcceptsQuarkusVersionQueries(String quarkusVersion) {
        return this.checkQuarkusVersion(quarkusVersion) >= 0;
    }

    int checkPlatform(ArtifactCoords platform) {
        if (!this.recognizedGroupIds.isEmpty() && !this.recognizedGroupIds.contains(platform.getGroupId())) {
            return -1;
        }
        return this.checkQuarkusVersion(platform.getVersion());
    }

    PlatformCatalog.Mutable resolvePlatformCatalog() throws RegistryResolutionException {
        return this.resolvePlatformCatalog(null);
    }

    PlatformCatalog.Mutable resolvePlatformCatalog(String quarkusCoreVersion) throws RegistryResolutionException {
        return this.extensionResolver.resolvePlatforms(quarkusCoreVersion);
    }

    Platform resolveRecommendedPlatform() throws RegistryResolutionException {
        return this.resolvePlatformCatalog().getRecommendedPlatform();
    }

    ExtensionCatalog.Mutable resolveNonPlatformExtensions(String quarkusCoreVersion) throws RegistryResolutionException {
        return this.extensionResolver.resolveNonPlatformExtensions(quarkusCoreVersion);
    }

    ExtensionCatalog.Mutable resolvePlatformExtensions(ArtifactCoords platform) throws RegistryResolutionException {
        ExtensionCatalog.Mutable catalog = this.extensionResolver.resolvePlatformExtensions(platform);
        if (this.offeringSupportKey == null) {
            return catalog;
        }
        Collection<Extension> originalCollection = catalog.getExtensions();
        ArrayList<Extension> filteredCollection = new ArrayList<Extension>(originalCollection.size());
        for (Extension ext : originalCollection) {
            if (ext.getMetadata().containsKey(this.offeringSupportKey)) {
                ext.getMetadata().put("registry-user-selected-support-key", this.offeringSupportKey);
                filteredCollection.add(ext);
                continue;
            }
            if (!ext.getArtifact().getArtifactId().equals("quarkus-core")) continue;
            filteredCollection.add(ext);
        }
        catalog.setExtensions(filteredCollection);
        return catalog;
    }

    void clearCache() throws RegistryResolutionException {
        this.extensionResolver.clearCache();
    }
}

