/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.client.maven;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.registry.client.maven.MavenRegistryArtifactResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;

public class MavenRegistryArtifactResolverWithCleanup
implements MavenRegistryArtifactResolver {
    private final MavenArtifactResolver resolver;
    private final boolean cleanupTimestampedVersions;

    public MavenRegistryArtifactResolverWithCleanup(MavenArtifactResolver resolver, boolean cleanupOldTimestampedVersions) {
        this.resolver = Objects.requireNonNull(resolver, "resolver can't be null");
        this.cleanupTimestampedVersions = cleanupOldTimestampedVersions;
    }

    @Override
    public ArtifactResult resolveArtifact(Artifact artifact) throws BootstrapMavenException {
        return MavenRegistryArtifactResolverWithCleanup.resolveAndCleanupOldTimestampedVersions(this.resolver, artifact, this.cleanupTimestampedVersions);
    }

    @Override
    public Path findArtifactDirectory(Artifact artifact) throws BootstrapMavenException {
        LocalRepositoryManager localRepo = this.resolver.getSession().getLocalRepositoryManager();
        return localRepo.getRepository().getBasedir().toPath().resolve(localRepo.getPathForLocalArtifact(artifact)).getParent();
    }

    @Override
    public String getLatestVersionFromRange(Artifact artifact, String versionRange) throws BootstrapMavenException {
        return this.resolver.getLatestVersionFromRange(artifact, versionRange);
    }

    protected static ArtifactResult resolveAndCleanupOldTimestampedVersions(MavenArtifactResolver resolver, Artifact artifact, boolean cleanupOldTimestampedVersions) throws BootstrapMavenException {
        if (!artifact.isSnapshot() || !cleanupOldTimestampedVersions) {
            return resolver.resolve(artifact);
        }
        LocalRepositoryManager localRepoManager = resolver.getSession().getLocalRepositoryManager();
        File jsonDir = new File(localRepoManager.getRepository().getBasedir(), localRepoManager.getPathForLocalArtifact(artifact)).getParentFile();
        List existingFiles = jsonDir.exists() ? Arrays.asList(jsonDir.list()) : Collections.emptyList();
        ArtifactResult result = resolver.resolve(artifact);
        File[] jsonDirContent = jsonDir.listFiles();
        if (jsonDirContent != null && jsonDirContent.length > existingFiles.size()) {
            String fileName = result.getArtifact().getFile().getName();
            for (File c : jsonDirContent) {
                if (c.getName().length() <= fileName.length() || !c.getName().startsWith(artifact.getArtifactId()) || !c.getName().endsWith(artifact.getClassifier()) || !existingFiles.contains(c.getName())) continue;
                c.deleteOnExit();
            }
        }
        return result;
    }

    @Override
    public org.apache.maven.artifact.repository.metadata.Metadata resolveMetadata(ArtifactResult result) throws BootstrapMavenException {
        List mdResults;
        Artifact artifact = result.getArtifact();
        DefaultMetadata md = new DefaultMetadata(artifact.getGroupId(), artifact.getArtifactId(), artifact.isSnapshot() ? artifact.getBaseVersion() : artifact.getVersion(), "maven-metadata.xml", artifact.isSnapshot() ? Metadata.Nature.SNAPSHOT : Metadata.Nature.RELEASE);
        MetadataRequest mdr = new MetadataRequest().setMetadata((Metadata)md);
        String repoId = result.getRepository().getId();
        if (repoId != null && !repoId.equals("local")) {
            for (RemoteRepository r : this.resolver.getRepositories()) {
                if (!r.getId().equals(repoId)) continue;
                mdr.setRepository(r);
                break;
            }
        }
        if (!(mdResults = this.resolver.getSystem().resolveMetadata(this.resolver.getSession(), Arrays.asList(mdr))).isEmpty() && (md = ((MetadataResult)mdResults.get(0)).getMetadata()) != null && md.getFile() != null && md.getFile().exists()) {
            org.apache.maven.artifact.repository.metadata.Metadata metadata;
            BufferedReader reader = new BufferedReader(new FileReader(md.getFile()));
            try {
                metadata = new MetadataXpp3Reader().read((Reader)reader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            reader.close();
            return metadata;
        }
        return null;
    }
}

