/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandlers;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.platform.catalog.processor.ExtensionProcessor;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionOrigin;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ListExtensionsCommandHandler
implements QuarkusCommandHandler {
    private static final String FULL_FORMAT = "%-8s %-50s %-50s %-25s%s";
    private static final String CONCISE_FORMAT = "%-50s %-50s";
    private static final String NAME_FORMAT = "%-50s";
    private static final String ORIGINS_FORMAT = "%-50s %-60s %s";

    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        Map installedByKey;
        BiConsumer<MessageWriter, Object[]> currentFormatter;
        Collection<Extension> extensions;
        MessageWriter log = invocation.log();
        boolean all = invocation.getValue("quarkus.list-extensions.all", true);
        boolean installedOnly = invocation.getValue("quarkus.list-extensions.installed", false);
        String format = invocation.getValue("quarkus.list-extensions.format", "");
        String search = invocation.getValue("quarkus.list-extensions.search", "*");
        String category = invocation.getValue("quarkus.list-extensions.category", "");
        boolean batchMode = invocation.getValue("quarkus.list-extensions.batch-mode", false);
        ExtensionManager extensionManager = invocation.getValue("quarkus.list-extensions.extension-manager", invocation.getQuarkusProject().getExtensionManager());
        Collection<Extension> collection = extensions = search == null ? invocation.getExtensionsCatalog().getExtensions() : QuarkusCommandHandlers.select(search, invocation.getExtensionsCatalog().getExtensions(), true).getExtensions();
        if (extensions.isEmpty()) {
            log.info("No extension found with pattern '%s'", new Object[]{search});
            return QuarkusCommandOutcome.success();
        }
        if (!batchMode) {
            String extensionStatus;
            String string = extensionStatus = all ? "available" : "installable";
            if (installedOnly) {
                extensionStatus = "installed";
            }
            log.info("Current Quarkus extensions %s: ", new Object[]{extensionStatus});
            log.info("");
        }
        switch (format.toLowerCase()) {
            case "full": {
                currentFormatter = this::fullFormatter;
                log.info(String.format(FULL_FORMAT, "Status", "Extension", "ArtifactId", "Updated Version", "Guide"));
                break;
            }
            case "origins": {
                currentFormatter = this::originsFormatter;
                break;
            }
            case "concise": {
                currentFormatter = this::conciseFormatter;
                break;
            }
            default: {
                currentFormatter = this::nameFormatter;
            }
        }
        try {
            installedByKey = extensionManager.getInstalled().stream().collect(Collectors.toMap(ArtifactCoords::getKey, Function.identity()));
        }
        catch (IOException e2) {
            throw new QuarkusCommandException("Failed to determine the list of installed extensions", e2);
        }
        Predicate<Extension> categoryFilter = category != null && !category.isBlank() ? e -> ExtensionProcessor.of(e).getCategories().contains(category) : e -> true;
        extensions.stream().filter(e -> !ExtensionProcessor.of(e).isUnlisted()).filter(categoryFilter).sorted(Comparator.comparing(e -> e.getArtifact().getArtifactId())).forEach(e -> this.display(log, (Extension)e, (ArtifactCoords)installedByKey.get(Extensions.toKey(e)), all, installedOnly, currentFormatter));
        return QuarkusCommandOutcome.success();
    }

    private void conciseFormatter(MessageWriter writer, Object[] cols) {
        Extension e = (Extension)cols[1];
        writer.info(String.format(CONCISE_FORMAT, e.getName(), e.getArtifact().getArtifactId()));
    }

    private void fullFormatter(MessageWriter writer, Object[] cols) {
        Extension e = (Extension)cols[1];
        String guide = ExtensionProcessor.getGuide(e);
        writer.info(String.format(FULL_FORMAT, cols[0], e.getName(), e.getArtifact().getArtifactId(), cols[2], guide == null ? "" : guide));
    }

    private void nameFormatter(MessageWriter writer, Object[] cols) {
        Extension e = (Extension)cols[1];
        writer.info(String.format(NAME_FORMAT, e.getArtifact().getArtifactId()));
    }

    private void originsFormatter(MessageWriter writer, Object[] cols) {
        ExtensionOrigin o;
        Extension e = (Extension)cols[1];
        String origin = null;
        int i = 0;
        List origins = e.getOrigins();
        while (i < origins.size() && origin == null) {
            if (!(o = (ExtensionOrigin)origins.get(i++)).isPlatform()) continue;
            origin = o.getBom().toString();
        }
        writer.info(String.format(ORIGINS_FORMAT, e.getName(), e.getArtifact().getVersion(), origin == null ? "" : origin));
        while (i < origins.size()) {
            if (!(o = (ExtensionOrigin)origins.get(i++)).isPlatform()) continue;
            writer.info(String.format(ORIGINS_FORMAT, "", "", o.getBom().toString()));
        }
    }

    private void display(MessageWriter messageWriter, Extension e, ArtifactCoords installed, boolean all, boolean installedOnly, BiConsumer<MessageWriter, Object[]> formatter) {
        if (installedOnly && installed == null) {
            return;
        }
        if (!installedOnly && !all && installed != null) {
            return;
        }
        String label = "";
        String version = "";
        if (installed != null) {
            if (e.getArtifact().getVersion().equals(installed.getVersion()) || installed.getVersion() == null) {
                label = "default";
                version = e.getArtifact().getVersion();
            } else {
                label = "custom*";
                version = String.format("%s* <> %s", installed.getVersion(), e.getArtifact().getVersion());
            }
        }
        formatter.accept(messageWriter, new Object[]{label, e, version});
    }
}

