/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.core.strategy;

import io.quarkus.devtools.codestarts.core.reader.TargetFile;
import io.quarkus.devtools.codestarts.core.strategy.CodestartFileStrategyHandler;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class AppendCodestartFileStrategyHandler
implements CodestartFileStrategyHandler {
    AppendCodestartFileStrategyHandler() {
    }

    @Override
    public String name() {
        return "append";
    }

    @Override
    public void process(Path targetDirectory, String relativePath, List<TargetFile> codestartFiles, Map<String, Object> data) throws IOException {
        this.checkNotEmptyCodestartFiles(codestartFiles);
        Path targetPath = targetDirectory.resolve(relativePath);
        this.checkTargetDoesNotExist(targetPath);
        this.createDirectories(targetPath);
        String content = codestartFiles.stream().map(TargetFile::getContent).collect(Collectors.joining(System.getProperty("line.separator")));
        this.writeFile(targetPath, content);
    }
}

