/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts;

import io.quarkus.devtools.codestarts.CodestartCatalogLoader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;

public interface CodestartResource {
    public String pathName();

    public String read(String var1);

    public Path copyTo(String var1, Path var2, CopyOption ... var3);

    public List<Source> listSources(String var1);

    public boolean dirExists(String var1);

    public List<String> getLanguageDirs();

    public Optional<Source> getSource(String var1, String var2);

    public static class PathCodestartResource
    implements CodestartResource {
        Path codestartDir;

        public PathCodestartResource(Path codestartDir) {
            this.codestartDir = codestartDir;
        }

        @Override
        public String pathName() {
            return this.codestartDir.toString();
        }

        @Override
        public String read(String codestartRelativePath) {
            try {
                return new String(Files.readAllBytes(this.codestartDir.resolve(codestartRelativePath)), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public List<Source> listSources(String languageDir) {
            List<Source> list;
            block8: {
                Path dir = this.codestartDir.resolve(languageDir);
                Stream<Path> pathStream = Files.walk(dir, new FileVisitOption[0]);
                try {
                    list = pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> dir.relativize((Path)path).toString()).map(n -> new Source(this, languageDir, (String)n)).collect(Collectors.toList());
                    if (pathStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (pathStream != null) {
                            try {
                                pathStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                pathStream.close();
            }
            return list;
        }

        @Override
        public boolean dirExists(String languageDir) {
            return Files.isDirectory(this.codestartDir.resolve(languageDir), new LinkOption[0]);
        }

        @Override
        public List<String> getLanguageDirs() {
            List<String> list;
            block8: {
                Stream<Path> files = Files.list(this.codestartDir);
                try {
                    list = files.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(CodestartCatalogLoader::getDirName).collect(Collectors.toList());
                    if (files == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (files != null) {
                            try {
                                files.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                files.close();
            }
            return list;
        }

        @Override
        public Optional<Source> getSource(String languageDir, String name) {
            Path path = this.codestartDir.resolve(languageDir).resolve(name);
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                return Optional.empty();
            }
            return Optional.of(new Source(this, languageDir, name));
        }

        @Override
        public Path copyTo(String codestartRelativePath, Path target, CopyOption ... copyOptions) {
            try {
                return Files.copy(this.codestartDir.resolve(codestartRelativePath), target, copyOptions);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static class Source {
        private final CodestartResource resource;
        private final String languageDir;
        private final String path;

        public Source(CodestartResource resource, String languageDir, String path) {
            this.resource = resource;
            this.languageDir = languageDir;
            this.path = path;
        }

        public CodestartResource getCodestartResource() {
            return this.resource;
        }

        public String getLanguageDir() {
            return this.languageDir;
        }

        public String getFileName() {
            return FilenameUtils.getName((String)this.path);
        }

        public String getFileDir() {
            return FilenameUtils.getPath((String)this.path);
        }

        public String path() {
            return this.path;
        }

        public String read() {
            return this.resource.read(this.pathInCodestart());
        }

        public Path copyTo(Path target, CopyOption ... copyOptions) {
            return this.resource.copyTo(this.pathInCodestart(), target, copyOptions);
        }

        public String pathInCodestart() {
            return this.languageDir + "/" + this.path;
        }

        public String absolutePath() {
            return this.resource.pathName() + "/" + this.pathInCodestart();
        }
    }
}

