/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.mssql.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.MSSQLServerContainer;
import org.testcontainers.utility.DockerImageName;

public class MSSQLDevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(MSSQLDevServicesProcessor.class);
    public static final String TAG = "2019-CU10-ubuntu-20.04";

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupMSSQL(final List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem) {
        return new DevServicesDatasourceProviderBuildItem("mssql", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, Optional<String> datasourceName, Optional<String> imageName, Map<String, String> additionalProperties, OptionalInt fixedExposedPort, LaunchMode launchMode, Optional<Duration> startupTimeout) {
                final QuarkusMSSQLServerContainer container = new QuarkusMSSQLServerContainer(imageName, fixedExposedPort, !devServicesSharedNetworkBuildItem.isEmpty());
                startupTimeout.ifPresent(arg_0 -> ((QuarkusMSSQLServerContainer)container).withStartupTimeout(arg_0));
                container.withPassword(password.orElse("Quarkuspassword1"));
                additionalProperties.forEach((arg_0, arg_1) -> ((QuarkusMSSQLServerContainer)container).withUrlParam(arg_0, arg_1));
                container.start();
                LOG.info((Object)"Dev Services for Microsoft SQL Server started.");
                return new DevServicesDatasourceProvider.RunningDevServicesDatasource(container.getEffectiveJdbcUrl(), container.getUsername(), container.getPassword(), new Closeable(){

                    @Override
                    public void close() throws IOException {
                        container.stop();
                        LOG.info((Object)"Dev Services for Microsoft SQL Server shut down.");
                    }
                });
            }
        });
    }

    private static class QuarkusMSSQLServerContainer
    extends MSSQLServerContainer {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private String hostName = null;

        public QuarkusMSSQLServerContainer(Optional<String> imageName, OptionalInt fixedExposedPort, boolean useSharedNetwork) {
            super(DockerImageName.parse((String)imageName.orElse(MSSQLServerContainer.IMAGE + ":2019-CU10-ubuntu-20.04")).asCompatibleSubstituteFor(MSSQLServerContainer.IMAGE));
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                this.hostName = ConfigureUtil.configureSharedNetwork((GenericContainer)this, (String)"mssql");
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), MSSQLServerContainer.MS_SQL_SERVER_PORT);
            } else {
                this.addExposedPort(MS_SQL_SERVER_PORT);
            }
        }

        public String getEffectiveJdbcUrl() {
            if (this.useSharedNetwork) {
                String additionalUrlParams = this.constructUrlParameters(";", ";");
                return "jdbc:sqlserver://" + this.hostName + ":" + MS_SQL_SERVER_PORT + additionalUrlParams;
            }
            return super.getJdbcUrl();
        }
    }
}

