/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.deployment.compose;

import io.quarkus.deployment.util.ExecUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.dockerclient.TransportConfig;
import org.testcontainers.utility.CommandLine;

public class ComposeRunner {
    private static final Logger LOG = Logger.getLogger(ComposeRunner.class);
    private static final String DOCKER_HOST_ENV = "DOCKER_HOST";
    private static final String DOCKER_CERT_PATH_ENV = "DOCKER_CERT_PATH";
    private static final String DOCKER_TLS_VERIFY_ENV = "DOCKER_TLS_VERIFY";
    private static final String PROJECT_NAME_ENV = "COMPOSE_PROJECT_NAME";
    private static final String COMPOSE_FILE_ENV = "COMPOSE_FILE";
    private static final String COMPOSE_PROFILES_ENV = "COMPOSE_PROFILES";
    private final List<File> composeFiles;
    private final String identifier;
    private final String composeExecutable;
    private String cmd;
    private Map<String, String> env;
    private List<String> profiles;

    public ComposeRunner(String composeExecutable, List<File> composeFiles, String projectName) {
        this.composeExecutable = composeExecutable;
        this.composeFiles = composeFiles;
        this.identifier = projectName;
        this.cmd = "";
        this.env = Collections.emptyMap();
        this.profiles = Collections.emptyList();
    }

    public ComposeRunner withCommand(String cmd) {
        this.cmd = cmd;
        return this;
    }

    public ComposeRunner withEnv(Map<String, String> env) {
        this.env = Collections.unmodifiableMap(env);
        return this;
    }

    public ComposeRunner withProfiles(List<String> profiles) {
        this.profiles = Collections.unmodifiableList(profiles);
        return this;
    }

    public void run() {
        if (!CommandLine.executableExists((String)this.composeExecutable)) {
            throw new RuntimeException("Docker Compose not found. Is " + this.composeExecutable + " on the PATH?");
        }
        if (this.composeFiles.isEmpty()) {
            LOG.info((Object)"No compose files specified");
            return;
        }
        HashMap<String, String> environment = new HashMap<String, String>(this.env);
        environment.put(PROJECT_NAME_ENV, this.identifier);
        TransportConfig transportConfig = DockerClientFactory.instance().getTransportConfig();
        String certPath = System.getenv(DOCKER_CERT_PATH_ENV);
        if (certPath != null) {
            environment.put(DOCKER_CERT_PATH_ENV, certPath);
            environment.put(DOCKER_TLS_VERIFY_ENV, "true");
        }
        environment.put(DOCKER_HOST_ENV, transportConfig.getDockerHost().toString());
        environment.put(COMPOSE_FILE_ENV, this.composeFiles.stream().map(File::getAbsolutePath).map(Objects::toString).collect(Collectors.joining(File.pathSeparator)));
        if (!this.profiles.isEmpty()) {
            environment.put(COMPOSE_PROFILES_ENV, String.join((CharSequence)",", this.profiles));
        }
        LOG.debugv("Compose is running with env {0}", environment);
        LOG.infov("Compose is running command: {0} {1}", (Object)this.composeExecutable, (Object)this.cmd);
        try {
            File pwd = this.composeFiles.get(0).getAbsoluteFile().getParentFile().getAbsoluteFile();
            int exitCode = ExecUtil.execProcess((Process)ExecUtil.startProcess((File)pwd, environment, (String)this.composeExecutable, (String[])this.cmd.split("\\s+")), is -> new ExecUtil.HandleOutput(is, Logger.Level.INFO, LOG));
            if (exitCode != 0) {
                throw new RuntimeException("Compose exited abnormally with code " + exitCode + " whilst running command: " + this.composeExecutable + " " + this.cmd + ", with env vars: " + String.valueOf(environment));
            }
            LOG.info((Object)"Compose has finished running");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error running Compose command: " + this.cmd, e);
        }
    }
}

