/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.common;

import io.quarkus.deployment.builditem.Startable;
import java.util.function.Function;
import org.testcontainers.containers.GenericContainer;

public class StartableContainer<T extends GenericContainer<?>>
implements Startable {
    private final T container;
    private final Function<T, String> connectionInfoFunction;

    public StartableContainer(T container) {
        this(container, null);
    }

    public StartableContainer(T container, Function<T, String> connectionInfoFunction) {
        this.container = container;
        this.connectionInfoFunction = connectionInfoFunction;
    }

    public void start() {
        this.container.start();
    }

    public String getConnectionInfo() {
        if (this.connectionInfoFunction == null) {
            return null;
        }
        return this.connectionInfoFunction.apply(this.container);
    }

    public T getContainer() {
        return this.container;
    }

    public String getContainerId() {
        return this.container.getContainerId();
    }

    public void close() {
        this.container.close();
    }
}

