/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.ExtensionCapabilities;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class CapabilityContract
implements ExtensionCapabilities,
Serializable {
    private final String extension;
    private final List<String> providesCapabilities;

    public static CapabilityContract providesCapabilities(String extension, String commaSeparatedList) {
        List<String> list = Arrays.asList(commaSeparatedList.split("\\s*,\\s*"));
        for (String provided : list) {
            if (!provided.isEmpty()) continue;
            throw new IllegalArgumentException("Extension " + extension + " was configured to provide a capability with an empty name: " + commaSeparatedList);
        }
        return new CapabilityContract(extension, list);
    }

    public CapabilityContract(String extension, List<String> providesCapabilities) {
        this.extension = Objects.requireNonNull(extension, "extension can't be null");
        this.providesCapabilities = Objects.requireNonNull(providesCapabilities, "providesCapabilities can't be null");
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    public List<String> getProvidesCapabilities() {
        return this.providesCapabilities;
    }
}

