/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.http;

import io.quarkus.amazon.lambda.http.DefaultLambdaAuthenticationRequest;
import io.quarkus.amazon.lambda.http.LambdaAuthenticationRequest;
import io.quarkus.amazon.lambda.http.model.AwsProxyRequest;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.vertx.http.runtime.QuarkusHttpHeaders;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@ApplicationScoped
public class LambdaHttpAuthenticationMechanism
implements HttpAuthenticationMechanism {
    @Inject
    Instance<IdentityProvider<LambdaAuthenticationRequest>> identityProviders;
    boolean useDefault;
    static final Set<Class<? extends AuthenticationRequest>> credentialTypes = new HashSet<Class<? extends AuthenticationRequest>>();

    @PostConstruct
    public void initialize() {
        this.useDefault = !this.identityProviders.iterator().hasNext();
    }

    public Uni<SecurityIdentity> authenticate(RoutingContext routingContext, IdentityProviderManager identityProviderManager) {
        AwsProxyRequest event;
        Map contextObjects;
        MultiMap qheaders = routingContext.request().headers();
        if (qheaders instanceof QuarkusHttpHeaders && (contextObjects = ((QuarkusHttpHeaders)qheaders).getContextObjects()).containsKey(AwsProxyRequest.class) && this.isAuthenticatable(event = (AwsProxyRequest)contextObjects.get(AwsProxyRequest.class))) {
            if (this.useDefault) {
                return identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new DefaultLambdaAuthenticationRequest(event), (RoutingContext)routingContext));
            }
            return identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new LambdaAuthenticationRequest(event), (RoutingContext)routingContext));
        }
        return Uni.createFrom().optional(Optional.empty());
    }

    private boolean isAuthenticatable(AwsProxyRequest event) {
        Map<String, String> systemEnvironment = System.getenv();
        boolean isSamLocal = Boolean.parseBoolean(systemEnvironment.get("AWS_SAM_LOCAL"));
        String forcedUserName = systemEnvironment.get("QUARKUS_AWS_LAMBDA_FORCE_USER_NAME");
        return isSamLocal && forcedUserName != null || event.getRequestContext() != null && (event.getRequestContext().getAuthorizer() != null || event.getRequestContext().getIdentity() != null && event.getRequestContext().getIdentity().getUser() != null);
    }

    public Uni<Boolean> sendChallenge(RoutingContext context) {
        return Uni.createFrom().item((Object)false);
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        return Uni.createFrom().nullItem();
    }

    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return credentialTypes;
    }

    public HttpCredentialTransport getCredentialTransport() {
        return null;
    }

    static {
        credentialTypes.add(LambdaAuthenticationRequest.class);
        credentialTypes.add(DefaultLambdaAuthenticationRequest.class);
    }
}

