/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.devtools.commands.ListExtensions;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.maven.QuarkusProjectMojoBase;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="list-extensions", requiresProject=false)
public class ListExtensionsMojo
extends QuarkusProjectMojoBase {
    private static final String DEFAULT_FORMAT = "concise";
    @Parameter(property="all", defaultValue="true")
    protected boolean all;
    @Parameter(property="format", defaultValue="concise")
    protected String format;
    @Parameter(property="searchPattern")
    protected String searchPattern;
    @Parameter(property="category")
    protected String category;
    @Parameter(property="installed", defaultValue="false")
    protected boolean installed;

    @Override
    public void doExecute(QuarkusProject quarkusProject, MessageWriter log) throws MojoExecutionException {
        try {
            ListExtensions listExtensions = new ListExtensions(quarkusProject).all(this.all).format(this.format).search(this.searchPattern).category(this.category).installed(this.installed);
            listExtensions.execute();
            if (DEFAULT_FORMAT.equalsIgnoreCase(this.format)) {
                log.info("");
                log.info("To get more information, append `%s` to your command line.", new Object[]{"-Dformat=full"});
            }
            if (!this.installed && (this.category == null || this.category.isBlank())) {
                log.info("");
                log.info("To list only extensions from specific category, append `%s` to your command line.", new Object[]{"-Dcategory=\"categoryId\""});
            }
            log.info("");
            log.info("Add an extension to your project by adding the dependency to your %s or use `%s`", new Object[]{"pom.xml", "./mvnw quarkus:add-extension -Dextensions=\"artifactId\""});
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to list extensions", e);
        }
    }
}

