/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.bootstrap.resolver.BootstrapAppModelResolver;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.maven.QuarkusBootstrapProvider;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.GACTV;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Consumer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="dependency-tree", defaultPhase=LifecyclePhase.NONE, requiresDependencyResolution=ResolutionScope.NONE)
public class DependencyTreeMojo
extends AbstractMojo {
    @Component
    protected QuarkusBootstrapProvider bootstrapProvider;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(property="mode", required=false, defaultValue="prod")
    String mode;
    @Parameter(property="outputFile", required=false)
    File outputFile;
    @Parameter(property="appendOutput", required=false, defaultValue="false")
    boolean appendOutput;
    protected MavenArtifactResolver resolver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Consumer<String> log;
        BufferedWriter writer = null;
        if (this.outputFile == null) {
            log = s -> this.getLog().info((CharSequence)s);
        } else {
            BufferedWriter bw;
            try {
                Files.createDirectories(this.outputFile.toPath().getParent(), new FileAttribute[0]);
                bw = writer = Files.newBufferedWriter(this.outputFile.toPath(), this.appendOutput && this.outputFile.exists() ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to initialize file output writer", (Exception)e);
            }
            log = s -> {
                try {
                    bw.write((String)s);
                    bw.newLine();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to log the dependency tree to a file", e);
                }
            };
        }
        try {
            this.logTree(log);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.getLog().debug((CharSequence)"Failed to close the output file", (Throwable)e);
                }
            }
        }
    }

    private void logTree(Consumer<String> log) throws MojoExecutionException {
        log.accept("Quarkus application " + this.mode.toUpperCase() + " mode build dependency tree:");
        GACTV appArtifact = new GACTV(this.project.getGroupId(), this.project.getArtifactId(), null, "pom", this.project.getVersion());
        try {
            BootstrapAppModelResolver modelResolver = new BootstrapAppModelResolver(this.resolver());
            if (this.mode != null) {
                if (this.mode.equalsIgnoreCase("test")) {
                    modelResolver.setTest(true);
                } else if (this.mode.equalsIgnoreCase("dev") || this.mode.equalsIgnoreCase("development")) {
                    modelResolver.setDevMode(true);
                } else if (!this.mode.equalsIgnoreCase("prod") && !this.mode.isEmpty()) {
                    throw new MojoExecutionException("Parameter 'mode' was set to '" + this.mode + "' while expected one of 'dev', 'test' or 'prod'");
                }
            }
            modelResolver.setBuildTreeLogger(log);
            modelResolver.resolveModel((ArtifactCoords)appArtifact);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve application model " + appArtifact + " dependencies", e);
        }
    }

    protected MavenArtifactResolver resolver() throws BootstrapMavenException {
        return this.resolver == null ? (this.resolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setRemoteRepositoryManager(this.bootstrapProvider.remoteRepositoryManager())).setRemoteRepositories(this.repos)).setPreferPomsFromWorkspace(true)).build()) : this.resolver;
    }
}

