/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.neo4j.deployment;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.time.Duration;

final class BoltHandshaker {
    private static final int magicToken = 1616949271;
    private static final byte[] versionsMessage = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final String address;
    private final int port;

    BoltHandshaker(String address, int port) {
        this.address = address;
        this.port = port;
    }

    private boolean doBoltHandshake(String address, int port, int timeoutMillis) {
        boolean bl;
        Socket socket = new Socket();
        try {
            socket.setSoTimeout(timeoutMillis);
            socket.connect(new InetSocketAddress(address, port), timeoutMillis);
            DataOutputStream dOut = new DataOutputStream(socket.getOutputStream());
            DataInputStream dIn = new DataInputStream(socket.getInputStream());
            dOut.writeInt(1616949271);
            dOut.flush();
            dOut.write(versionsMessage);
            dOut.flush();
            int response = dIn.readInt();
            assert (response == 0);
            bl = dIn.read() == -1;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    boolean isBoltPortReachable(Duration timeout) {
        int timeoutMillis = Math.toIntExact(timeout.toMillis());
        return this.doBoltHandshake(this.address, this.port, timeoutMillis);
    }
}

