/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime.config;

import io.quarkiverse.mcp.server.McpLog;
import io.smallrye.config.WithDefault;
import java.time.Duration;
import java.util.Optional;

public interface McpServerRuntimeConfig {
    public ServerInfo serverInfo();

    public TrafficLogging trafficLogging();

    public ClientLogging clientLogging();

    public Optional<Duration> autoPingInterval();

    public Resources resources();

    public ResourceTemplates resourceTemplates();

    public Tools tools();

    public Prompts prompts();

    public Sampling sampling();

    public Roots roots();

    public DevMode devMode();

    @WithDefault(value="30m")
    public Duration connectionIdleTimeout();

    public static interface Roots {
        @WithDefault(value="60s")
        public Duration defaultTimeout();
    }

    public static interface Sampling {
        @WithDefault(value="60s")
        public Duration defaultTimeout();
    }

    public static interface Tools {
        @WithDefault(value="50")
        public int pageSize();
    }

    public static interface Prompts {
        @WithDefault(value="50")
        public int pageSize();
    }

    public static interface ResourceTemplates {
        @WithDefault(value="50")
        public int pageSize();
    }

    public static interface Resources {
        @WithDefault(value="50")
        public int pageSize();
    }

    public static interface DevMode {
        @WithDefault(value="true")
        public boolean dummyInit();
    }

    public static interface ClientLogging {
        @WithDefault(value="INFO")
        public McpLog.LogLevel defaultLevel();
    }

    public static interface ServerInfo {
        public Optional<String> name();

        public Optional<String> version();
    }

    public static interface TrafficLogging {
        @WithDefault(value="false")
        public boolean enabled();

        @WithDefault(value="200")
        public int textLimit();
    }
}

