/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.ToolCallException;
import io.quarkiverse.mcp.server.ToolManager;
import io.quarkiverse.mcp.server.ToolResponse;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.Cursor;
import io.quarkiverse.mcp.server.runtime.FeatureManagerBase;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.McpRequest;
import io.quarkiverse.mcp.server.runtime.MessageHandler;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.Page;
import io.quarkiverse.mcp.server.runtime.ToolManagerImpl;
import io.quarkiverse.mcp.server.runtime.config.McpServerRuntimeConfig;
import io.quarkiverse.mcp.server.runtime.config.McpServersRuntimeConfig;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Objects;
import org.jboss.logging.Logger;

class ToolMessageHandler
extends MessageHandler {
    private static final Logger LOG = Logger.getLogger(ToolMessageHandler.class);
    private final ToolManagerImpl manager;
    private final McpServersRuntimeConfig config;

    ToolMessageHandler(ToolManagerImpl manager, McpServersRuntimeConfig config) {
        this.manager = Objects.requireNonNull(manager);
        this.config = config;
    }

    Future<Void> toolsList(JsonObject message, McpRequest mcpRequest) {
        Object id = message.getValue("id");
        Cursor cursor = Messages.getCursor(message, mcpRequest.sender());
        if (cursor == null) {
            return Future.succeededFuture();
        }
        LOG.debugf("List tools [id: %s, cursor: %s]", id, (Object)cursor);
        McpServerRuntimeConfig serverConfig = this.config.servers().get(mcpRequest.serverName());
        if (serverConfig == null) {
            throw new IllegalStateException("Server config not found: " + mcpRequest.serverName());
        }
        int pageSize = serverConfig.tools().pageSize();
        JsonArray tools = new JsonArray();
        JsonObject result = new JsonObject().put("tools", (Object)tools);
        Page page = this.manager.fetchPage(mcpRequest, cursor, pageSize);
        for (ToolManager.ToolInfo info : page) {
            tools.add((Object)info.asJson());
        }
        if (page.hasNextCursor()) {
            ToolManager.ToolInfo last = (ToolManager.ToolInfo)page.lastInfo();
            result.put("nextCursor", (Object)Cursor.encode(last.createdAt(), last.name()));
        }
        return mcpRequest.sender().sendResult(id, result);
    }

    Future<Void> toolsCall(JsonObject message, McpRequest mcpRequest) {
        Object id = message.getValue("id");
        JsonObject params = message.getJsonObject("params");
        String toolName = params.getString("name");
        LOG.debugf("Call tool %s [id: %s]", (Object)toolName, id);
        HashMap<String, Object> args = params.containsKey("arguments") ? params.getJsonObject("arguments").getMap() : new HashMap();
        ArgumentProviders argProviders = new ArgumentProviders(args, mcpRequest.connection(), id, null, mcpRequest.sender(), Messages.getProgressToken(message), this.manager.responseHandlers, mcpRequest.serverName());
        try {
            Future fu = this.manager.execute(toolName, new FeatureManagerBase.FeatureExecutionContext(argProviders, mcpRequest));
            return fu.compose(toolResponse -> mcpRequest.sender().sendResult(id, toolResponse), cause -> {
                if (cause instanceof ToolCallException) {
                    ToolCallException tce = (ToolCallException)cause;
                    return mcpRequest.sender().sendResult(id, ToolResponse.error(tce.getMessage()));
                }
                return this.handleFailure(id, mcpRequest.sender(), mcpRequest.connection(), (Throwable)cause, LOG, "Unable to call tool %s", toolName);
            });
        }
        catch (McpException e) {
            return mcpRequest.sender().sendError(id, e.getJsonRpcError(), e.getMessage());
        }
    }
}

