/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import io.quarkiverse.mcp.server.DefaultValueConverter;
import io.quarkiverse.mcp.server.McpConnection;
import io.quarkiverse.mcp.server.RequestId;
import io.quarkiverse.mcp.server.ToolFilter;
import io.quarkiverse.mcp.server.ToolManager;
import io.quarkiverse.mcp.server.ToolResponse;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.Feature;
import io.quarkiverse.mcp.server.runtime.FeatureArgument;
import io.quarkiverse.mcp.server.runtime.FeatureManagerBase;
import io.quarkiverse.mcp.server.runtime.FeatureMetadata;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.McpMetadata;
import io.quarkiverse.mcp.server.runtime.McpRequest;
import io.quarkiverse.mcp.server.runtime.ProgressImpl;
import io.quarkiverse.mcp.server.runtime.ResponseHandlers;
import io.quarkiverse.mcp.server.runtime.RootsImpl;
import io.quarkiverse.mcp.server.runtime.SamplingImpl;
import io.quarkiverse.mcp.server.runtime.SchemaGeneratorConfigCustomizer;
import io.quarkiverse.mcp.server.runtime.Types;
import io.quarkus.arc.All;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

@Singleton
public class ToolManagerImpl
extends FeatureManagerBase<ToolResponse, ToolManager.ToolInfo>
implements ToolManager {
    private static final Logger LOG = Logger.getLogger(ToolManagerImpl.class);
    private final SchemaGenerator schemaGenerator;
    final ConcurrentMap<String, ToolManager.ToolInfo> tools = new ConcurrentHashMap<String, ToolManager.ToolInfo>();
    final Map<Type, DefaultValueConverter<?>> defaultValueConverters;
    final List<ToolFilter> filters;

    ToolManagerImpl(McpMetadata metadata, Vertx vertx, ObjectMapper mapper, ConnectionManager connectionManager, Instance<CurrentIdentityAssociation> currentIdentityAssociation, ResponseHandlers responseHandlers, @All List<ToolFilter> filters, @All List<SchemaGeneratorConfigCustomizer> schemaGeneratorConfigCustomizers) {
        super(vertx, mapper, connectionManager, currentIdentityAssociation, responseHandlers);
        for (FeatureMetadata<ToolResponse> f : metadata.tools()) {
            this.tools.put(f.info().name(), new ToolMethod(f));
        }
        this.schemaGenerator = ToolManagerImpl.constructSchemaGenerator(schemaGeneratorConfigCustomizers);
        this.defaultValueConverters = metadata.defaultValueConverters();
        this.filters = filters;
    }

    @Override
    Stream<ToolManager.ToolInfo> infos() {
        return this.tools.values().stream();
    }

    @Override
    Stream<ToolManager.ToolInfo> filter(Stream<ToolManager.ToolInfo> infos, McpConnection connection) {
        return infos.filter(t -> this.test((ToolManager.ToolInfo)t, connection));
    }

    @Override
    public ToolManager.ToolInfo getTool(String name) {
        return (ToolManager.ToolInfo)this.tools.get(Objects.requireNonNull(name));
    }

    @Override
    public ToolManager.ToolDefinition newTool(String name) {
        if (this.tools.containsKey(name)) {
            throw this.toolAlreadyExists(name);
        }
        return new ToolDefinitionImpl(name);
    }

    IllegalArgumentException toolAlreadyExists(String name) {
        return new IllegalArgumentException("A tool with name [" + name + "] already exits");
    }

    @Override
    public ToolManager.ToolInfo removeTool(String name) {
        AtomicReference removed = new AtomicReference();
        this.tools.computeIfPresent(name, (key, value) -> {
            if (!value.isMethod()) {
                removed.set(value);
                this.notifyConnections("notifications/tools/list_changed");
                return null;
            }
            return value;
        });
        return (ToolManager.ToolInfo)removed.get();
    }

    @Override
    protected FeatureManagerBase.FeatureInvoker<ToolResponse> getInvoker(String id, McpRequest mcpRequest) {
        ToolManager.ToolInfo tool = (ToolManager.ToolInfo)this.tools.get(id);
        if (tool instanceof FeatureManagerBase.FeatureInvoker) {
            FeatureManagerBase.FeatureInvoker fi = (FeatureManagerBase.FeatureInvoker)((Object)tool);
            if (this.matches(tool, mcpRequest) && this.test(tool, mcpRequest.connection())) {
                return fi;
            }
        }
        return null;
    }

    @Override
    protected McpException notFound(String id) {
        return new McpException("Invalid tool name: " + id, -32602);
    }

    @Override
    protected Map<Type, DefaultValueConverter<?>> defaultValueConverters() {
        return this.defaultValueConverters;
    }

    Object generateSchema(Type type, String description, String defaultValue) {
        ObjectNode jsonNode = this.schemaGenerator.generateSchema(type, new Type[0]);
        if (jsonNode.isObject()) {
            ObjectNode valueProp;
            ObjectNode objectNode = jsonNode;
            if (Types.isOptional(type) && (valueProp = objectNode.withObjectProperty("properties").withObjectProperty("value")) != null) {
                objectNode = valueProp;
            }
            if (description != null && !description.isBlank()) {
                objectNode.put("description", description);
            }
            if (defaultValue != null) {
                Object converted = this.convert(defaultValue, type);
                objectNode.putPOJO("default", converted);
            }
            return objectNode;
        }
        return jsonNode;
    }

    private boolean test(ToolManager.ToolInfo tool, McpConnection connection) {
        if (this.filters.isEmpty() || connection == null) {
            return true;
        }
        for (ToolFilter filter : this.filters) {
            try {
                if (filter.test(tool, connection)) continue;
                return false;
            }
            catch (RuntimeException e) {
                LOG.errorf((Throwable)e, "Unable to apply filter: %s", (Object)filter);
            }
        }
        return true;
    }

    private static SchemaGenerator constructSchemaGenerator(List<SchemaGeneratorConfigCustomizer> schemaGeneratorConfigCustomizers) {
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON).without(Option.SCHEMA_VERSION_INDICATOR, new Option[0]);
        for (SchemaGeneratorConfigCustomizer customizer : schemaGeneratorConfigCustomizers) {
            customizer.customize(configBuilder);
        }
        return new SchemaGenerator(configBuilder.build());
    }

    class ToolMethod
    extends FeatureManagerBase.FeatureMetadataInvoker<ToolResponse>
    implements ToolManager.ToolInfo {
        private ToolMethod(FeatureMetadata<ToolResponse> metadata) {
            super(metadata);
        }

        @Override
        public String name() {
            return this.metadata.info().name();
        }

        @Override
        public String description() {
            return this.metadata.info().description();
        }

        @Override
        public String serverName() {
            return this.metadata.info().serverName();
        }

        @Override
        public boolean isMethod() {
            return true;
        }

        @Override
        public Optional<ToolManager.ToolAnnotations> annotations() {
            return Optional.ofNullable(this.metadata.info().toolAnnotations());
        }

        @Override
        public List<ToolManager.ToolArgument> arguments() {
            return this.metadata.info().serializedArguments().stream().map(fa -> new ToolManager.ToolArgument(fa.name(), fa.description(), fa.required(), fa.type(), fa.defaultValue())).toList();
        }

        @Override
        public JsonObject asJson() {
            JsonObject tool = this.metadata.asJson();
            JsonObject properties = new JsonObject();
            JsonArray required = new JsonArray();
            for (FeatureArgument a : this.metadata.info().serializedArguments()) {
                properties.put(a.name(), ToolManagerImpl.this.generateSchema(a.type(), a.description(), a.defaultValue()));
                if (!a.required()) continue;
                required.add((Object)a.name());
            }
            ToolManager.ToolAnnotations toolAnnotations = this.metadata.info().toolAnnotations();
            if (toolAnnotations != null) {
                tool.put("annotations", (Object)new JsonObject().put("title", (Object)toolAnnotations.title()).put("destructiveHint", (Object)toolAnnotations.destructiveHint()).put("idempotentHint", (Object)toolAnnotations.idempotentHint()).put("openWorldHint", (Object)toolAnnotations.openWorldHint()).put("readOnlyHint", (Object)toolAnnotations.readOnlyHint()));
            }
            tool.put("inputSchema", (Object)new JsonObject().put("type", (Object)"object").put("properties", (Object)properties).put("required", (Object)required));
            return tool;
        }
    }

    class ToolDefinitionImpl
    extends FeatureManagerBase.FeatureDefinitionBase<ToolManager.ToolInfo, ToolManager.ToolArguments, ToolResponse, ToolDefinitionImpl>
    implements ToolManager.ToolDefinition {
        private final List<ToolManager.ToolArgument> arguments;
        private ToolManager.ToolAnnotations annotations;

        private ToolDefinitionImpl(String name) {
            super(name);
            this.arguments = new ArrayList<ToolManager.ToolArgument>();
        }

        @Override
        public ToolManager.ToolDefinition addArgument(String name, String description, boolean required, Type type, String defaultValue) {
            this.arguments.add(new ToolManager.ToolArgument(name, description, required, type, defaultValue));
            return this;
        }

        @Override
        public ToolManager.ToolDefinition setAnnotations(ToolManager.ToolAnnotations annotations) {
            this.annotations = annotations;
            return this;
        }

        @Override
        public ToolManager.ToolInfo register() {
            this.validate();
            ToolDefinitionInfo ret = new ToolDefinitionInfo(this.name, this.description, this.serverName, this.fun, this.asyncFun, this.runOnVirtualThread, this.arguments, this.annotations);
            ToolManager.ToolInfo existing = ToolManagerImpl.this.tools.putIfAbsent(this.name, ret);
            if (existing != null) {
                throw ToolManagerImpl.this.toolAlreadyExists(this.name);
            }
            ToolManagerImpl.this.notifyConnections("notifications/tools/list_changed");
            return ret;
        }
    }

    class ToolDefinitionInfo
    extends FeatureManagerBase.FeatureDefinitionInfoBase<ToolManager.ToolArguments, ToolResponse>
    implements ToolManager.ToolInfo {
        private final List<ToolManager.ToolArgument> arguments;
        private final Optional<ToolManager.ToolAnnotations> annotations;

        private ToolDefinitionInfo(String name, String description, String serverName, Function<ToolManager.ToolArguments, ToolResponse> fun, Function<ToolManager.ToolArguments, Uni<ToolResponse>> asyncFun, boolean runOnVirtualThread, List<ToolManager.ToolArgument> arguments, ToolManager.ToolAnnotations annotations) {
            super(name, description, serverName, fun, asyncFun, runOnVirtualThread);
            this.arguments = List.copyOf(arguments);
            this.annotations = Optional.ofNullable(annotations);
        }

        @Override
        public List<ToolManager.ToolArgument> arguments() {
            return this.arguments;
        }

        @Override
        public Optional<ToolManager.ToolAnnotations> annotations() {
            return this.annotations;
        }

        @Override
        public JsonObject asJson() {
            JsonObject tool = new JsonObject().put("name", (Object)this.name()).put("description", (Object)this.description());
            JsonObject properties = new JsonObject();
            JsonArray required = new JsonArray();
            for (ToolManager.ToolArgument a : this.arguments) {
                properties.put(a.name(), ToolManagerImpl.this.generateSchema(a.type(), a.description(), a.defaultValue()));
                if (!a.required()) continue;
                required.add((Object)a.name());
            }
            if (this.annotations.isPresent()) {
                tool.put("annotations", (Object)new JsonObject().put("title", (Object)this.annotations.get().title()).put("destructiveHint", (Object)this.annotations.get().destructiveHint()).put("idempotentHint", (Object)this.annotations.get().idempotentHint()).put("openWorldHint", (Object)this.annotations.get().openWorldHint()).put("readOnlyHint", (Object)this.annotations.get().readOnlyHint()));
            }
            tool.put("inputSchema", (Object)new JsonObject().put("type", (Object)"object").put("properties", (Object)properties).put("required", (Object)required));
            return tool;
        }

        @Override
        protected ToolManager.ToolArguments createArguments(ArgumentProviders argumentProviders) {
            Map<String, Object> args = argumentProviders.args();
            for (ToolManager.ToolArgument a : this.arguments) {
                if (a.defaultValue() == null || args.containsKey(a.name())) continue;
                args.put(a.name(), ToolManagerImpl.this.convert(a.defaultValue(), a.type()));
            }
            return new ToolManager.ToolArguments(args, argumentProviders.connection(), ToolManagerImpl.this.log(Feature.TOOL.toString().toLowerCase() + ":" + this.name, this.name, argumentProviders), new RequestId(argumentProviders.requestId()), ProgressImpl.from(argumentProviders), RootsImpl.from(argumentProviders), SamplingImpl.from(argumentProviders));
        }
    }
}

