/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import io.quarkiverse.mcp.server.runtime.SchemaGeneratorConfigCustomizer;
import io.quarkiverse.mcp.server.runtime.config.McpServerSchemaGeneratorJacksonRuntimeConfig;
import jakarta.enterprise.context.Dependent;
import java.util.ArrayList;

@Dependent
public class SchemaGeneratorConfigCustomizerJackson
implements SchemaGeneratorConfigCustomizer {
    private final McpServerSchemaGeneratorJacksonRuntimeConfig config;

    public SchemaGeneratorConfigCustomizerJackson(McpServerSchemaGeneratorJacksonRuntimeConfig config) {
        this.config = config;
    }

    @Override
    public void customize(SchemaGeneratorConfigBuilder builder) {
        if (this.config.enabled()) {
            JacksonOption[] configuredOptions = this.getConfiguredOptions();
            Module jacksonModule = this.createJacksonModule(configuredOptions);
            builder.with(jacksonModule);
        }
    }

    Module createJacksonModule(JacksonOption[] options) {
        return new JacksonModule(options);
    }

    private JacksonOption[] getConfiguredOptions() {
        ArrayList<JacksonOption> options = new ArrayList<JacksonOption>();
        if (this.config.respectJsonPropertyOrder()) {
            options.add(JacksonOption.RESPECT_JSONPROPERTY_ORDER);
        }
        if (this.config.respectJsonPropertyRequired()) {
            options.add(JacksonOption.RESPECT_JSONPROPERTY_REQUIRED);
        }
        if (this.config.flattenedEnumsFromJsonValue()) {
            options.add(JacksonOption.FLATTENED_ENUMS_FROM_JSONVALUE);
        }
        if (this.config.flattenedEnumsFromJsonProperty()) {
            options.add(JacksonOption.FLATTENED_ENUMS_FROM_JSONPROPERTY);
        }
        if (this.config.includeOnlyJsonPropertyAnnotatedMethods()) {
            options.add(JacksonOption.INCLUDE_ONLY_JSONPROPERTY_ANNOTATED_METHODS);
        }
        if (this.config.ignorePropertyNamingStrategy()) {
            options.add(JacksonOption.IGNORE_PROPERTY_NAMING_STRATEGY);
        }
        if (this.config.alwaysRefSubtypes()) {
            options.add(JacksonOption.ALWAYS_REF_SUBTYPES);
        }
        if (this.config.inlineTransformedSubtypes()) {
            options.add(JacksonOption.INLINE_TRANSFORMED_SUBTYPES);
        }
        if (this.config.skipSubtypeLookup()) {
            options.add(JacksonOption.SKIP_SUBTYPE_LOOKUP);
        }
        if (this.config.ignoreTypeInfoTransform()) {
            options.add(JacksonOption.IGNORE_TYPE_INFO_TRANSFORM);
        }
        if (this.config.jsonIdentityReferenceAlwaysAsId()) {
            options.add(JacksonOption.JSONIDENTITY_REFERENCE_ALWAYS_AS_ID);
        }
        return (JacksonOption[])options.toArray(JacksonOption[]::new);
    }
}

