/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkiverse.mcp.server.Content;
import io.quarkiverse.mcp.server.ImageContent;
import io.quarkiverse.mcp.server.ModelPreferences;
import io.quarkiverse.mcp.server.Role;
import io.quarkiverse.mcp.server.SamplingMessage;
import io.quarkiverse.mcp.server.SamplingRequest;
import io.quarkiverse.mcp.server.SamplingResponse;
import io.quarkiverse.mcp.server.TextContent;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.ResponseHandlers;
import io.quarkiverse.mcp.server.runtime.Sender;
import io.smallrye.mutiny.TimeoutException;
import io.smallrye.mutiny.Uni;
import io.vertx.core.json.JsonObject;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.logging.Logger;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SamplingRequestImpl
implements SamplingRequest {
    private static final Logger LOG = Logger.getLogger(SamplingRequestImpl.class);
    private final long maxTokens;
    private final List<SamplingMessage> messages;
    private final BigDecimal temperature;
    private final String systemPrompt;
    private final SamplingRequest.IncludeContext includeContext;
    private final ModelPreferences modelPreferences;
    private final Map<String, Object> metadata;
    private final List<String> stopSequences;
    private final Sender sender;
    private final ResponseHandlers responseHandlers;
    private final Duration timeout;

    SamplingRequestImpl(long maxTokens, List<SamplingMessage> messages, BigDecimal temperature, String systemPrompt, SamplingRequest.IncludeContext includeContext, ModelPreferences modelPreferences, Map<String, Object> metadata, List<String> stopSequences, Sender sender, ResponseHandlers responseHandlers, Duration timeout) {
        this.maxTokens = maxTokens;
        this.messages = messages;
        this.temperature = temperature;
        this.systemPrompt = systemPrompt;
        this.includeContext = includeContext;
        this.modelPreferences = modelPreferences;
        this.metadata = metadata;
        this.stopSequences = stopSequences;
        this.sender = sender;
        this.responseHandlers = responseHandlers;
        this.timeout = timeout;
    }

    @Override
    @JsonProperty
    public long maxTokens() {
        return this.maxTokens;
    }

    @Override
    @JsonProperty
    public List<SamplingMessage> messages() {
        return this.messages;
    }

    @Override
    @JsonProperty
    public List<String> stopSequences() {
        return this.stopSequences;
    }

    @Override
    @JsonProperty
    public String systemPrompt() {
        return this.systemPrompt;
    }

    @Override
    @JsonProperty
    public BigDecimal temperature() {
        return this.temperature;
    }

    @Override
    @JsonProperty
    public SamplingRequest.IncludeContext includeContext() {
        return this.includeContext;
    }

    @Override
    @JsonProperty
    public ModelPreferences modelPreferences() {
        return this.modelPreferences;
    }

    @Override
    @JsonProperty
    public Map<String, Object> metadata() {
        return this.metadata;
    }

    @Override
    public Uni<SamplingResponse> send() {
        AtomicLong id = new AtomicLong();
        Uni ret = Uni.createFrom().completionStage(() -> {
            CompletableFuture future = new CompletableFuture();
            Long requestId = this.responseHandlers.newRequest(m -> {
                JsonObject result = m.getJsonObject("result");
                if (result == null) {
                    throw new IllegalStateException("Invalid sampling response: " + String.valueOf(m));
                }
                String model = result.getString("model");
                Role role = Role.valueOf(result.getString("role").toUpperCase());
                JsonObject content = result.getJsonObject("content");
                Content.Type contentType = Content.Type.valueOf(content.getString("type").toUpperCase());
                Record c = switch (contentType) {
                    case Content.Type.TEXT -> (TextContent)content.mapTo(TextContent.class);
                    case Content.Type.IMAGE -> (ImageContent)content.mapTo(ImageContent.class);
                    default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)contentType));
                };
                SamplingResponse samplingResponse = new SamplingResponse((Content)((Object)c), model, role, result.getString("stopReason"));
                future.complete(samplingResponse);
            });
            id.set(requestId);
            this.sender.send(Messages.newRequest(id, "sampling/createMessage", this));
            return future;
        });
        if (!this.timeout.isNegative() && !this.timeout.isZero()) {
            ret = ret.ifNoItem().after(this.timeout).fail().onFailure(TimeoutException.class).invoke(te -> {
                long requestId = id.get();
                if (requestId != 0L && this.responseHandlers.remove(requestId)) {
                    LOG.debugf("Response handler for %s removed due to timeout", requestId);
                }
            });
        }
        return ret;
    }
}

