/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.mcp.server.CompletionResponse;
import io.quarkiverse.mcp.server.ResourceTemplateCompletionManager;
import io.quarkiverse.mcp.server.runtime.CompletionManagerBase;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.Feature;
import io.quarkiverse.mcp.server.runtime.FeatureArgument;
import io.quarkiverse.mcp.server.runtime.FeatureMetadata;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.McpMetadata;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResponseHandlers;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.vertx.core.Vertx;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;

@Singleton
public class ResourceTemplateCompletionManagerImpl
extends CompletionManagerBase
implements ResourceTemplateCompletionManager {
    private final ResourceTemplateManagerImpl resourceTemplateManager;

    ResourceTemplateCompletionManagerImpl(McpMetadata metadata, Vertx vertx, ObjectMapper mapper, ConnectionManager connectionManager, ResourceTemplateManagerImpl resourceTemplateManager, Instance<CurrentIdentityAssociation> currentIdentityAssociation, ResponseHandlers responseHandlers) {
        super(vertx, mapper, connectionManager, currentIdentityAssociation, responseHandlers);
        for (FeatureMetadata<CompletionResponse> c : metadata.resourceTemplateCompletions()) {
            String key = c.info().name() + "_" + c.info().arguments().stream().filter(FeatureArgument::isParam).findFirst().orElseThrow().name();
            this.completions.put(key, new CompletionManagerBase.CompletionMethod(this, c));
        }
        this.resourceTemplateManager = resourceTemplateManager;
    }

    @Override
    protected McpException notFound(String id) {
        return new McpException("Resource template completion does not exist: " + id, -32602);
    }

    @Override
    protected Feature feature() {
        return Feature.RESOURCE_TEMPLATE_COMPLETE;
    }

    @Override
    protected void validateReference(String refName, String argumentName) {
        ResourceTemplateManagerImpl.ResourceTemplateMetadata templateMeta = (ResourceTemplateManagerImpl.ResourceTemplateMetadata)this.resourceTemplateManager.templates.get(refName);
        if (templateMeta == null) {
            throw new IllegalStateException("Resource template does not exist: " + refName);
        }
        if (!templateMeta.variableMatcher().variables().contains(argumentName)) {
            throw new IllegalStateException("Resource template [" + refName + "] does not define argument: " + argumentName);
        }
    }
}

