/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.ResourceManager;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.Cursor;
import io.quarkiverse.mcp.server.runtime.FeatureManagerBase;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.McpRequest;
import io.quarkiverse.mcp.server.runtime.MessageHandler;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.Page;
import io.quarkiverse.mcp.server.runtime.ResourceManagerImpl;
import io.quarkiverse.mcp.server.runtime.config.McpServerRuntimeConfig;
import io.quarkiverse.mcp.server.runtime.config.McpServersRuntimeConfig;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import java.util.Objects;
import org.jboss.logging.Logger;

class ResourceMessageHandler
extends MessageHandler {
    private static final Logger LOG = Logger.getLogger(ResourceMessageHandler.class);
    private final ResourceManagerImpl manager;
    private final McpServersRuntimeConfig config;

    ResourceMessageHandler(ResourceManagerImpl manager, McpServersRuntimeConfig config) {
        this.manager = Objects.requireNonNull(manager);
        this.config = config;
    }

    Future<Void> resourcesSubscribe(JsonObject message, McpRequest mcpRequest) {
        Object id = message.getValue("id");
        JsonObject params = message.getJsonObject("params");
        String resourceUri = params.getString("uri");
        if (resourceUri == null) {
            return mcpRequest.sender().sendError(id, -32602, "Resource URI not defined");
        }
        LOG.debugf("Subscribe to resource %s [id: %s]", (Object)resourceUri, id);
        this.manager.subscribe(resourceUri, mcpRequest);
        return mcpRequest.sender().sendResult(id, new JsonObject());
    }

    Future<Void> resourcesUnsubscribe(JsonObject message, McpRequest mcpRequest) {
        Object id = message.getValue("id");
        JsonObject params = message.getJsonObject("params");
        String resourceUri = params.getString("uri");
        if (resourceUri == null) {
            return mcpRequest.sender().sendError(id, -32602, "Resource URI not defined");
        }
        LOG.debugf("Unsubscribe to resource %s [id: %s]", (Object)resourceUri, id);
        this.manager.unsubscribe(resourceUri, mcpRequest.connection().id());
        return mcpRequest.sender().sendResult(id, new JsonObject());
    }

    Future<Void> resourcesList(JsonObject message, McpRequest mcpRequest) {
        Object id = message.getValue("id");
        Cursor cursor = Messages.getCursor(message, mcpRequest.sender());
        if (cursor == null) {
            return Future.succeededFuture();
        }
        LOG.debugf("List resources [id: %s, cursor: %s]", id, (Object)cursor);
        McpServerRuntimeConfig serverConfig = this.config.servers().get(mcpRequest.serverName());
        if (serverConfig == null) {
            throw new IllegalStateException("Server config not found: " + mcpRequest.serverName());
        }
        int pageSize = serverConfig.resources().pageSize();
        JsonArray resources = new JsonArray();
        JsonObject result = new JsonObject().put("resources", (Object)resources);
        Page page = this.manager.fetchPage(mcpRequest, cursor, pageSize);
        for (ResourceManager.ResourceInfo info : page) {
            resources.add((Object)info.asJson());
        }
        if (page.hasNextCursor()) {
            ResourceManager.ResourceInfo last = (ResourceManager.ResourceInfo)page.lastInfo();
            result.put("nextCursor", (Object)Cursor.encode(last.createdAt(), last.name()));
        }
        return mcpRequest.sender().sendResult(id, result);
    }

    Future<Void> resourcesRead(JsonObject message, McpRequest mcpRequest) {
        Object id = message.getValue("id");
        JsonObject params = message.getJsonObject("params");
        String resourceUri = params.getString("uri");
        if (resourceUri == null) {
            return mcpRequest.sender().sendError(id, -32602, "Resource URI not defined");
        }
        LOG.debugf("Read resource %s [id: %s]", (Object)resourceUri, id);
        ArgumentProviders argProviders = new ArgumentProviders(Map.of(), mcpRequest.connection(), id, resourceUri, mcpRequest.sender(), Messages.getProgressToken(message), this.manager.responseHandlers, mcpRequest.serverName());
        try {
            Future fu = this.manager.execute(resourceUri, new FeatureManagerBase.FeatureExecutionContext(argProviders, mcpRequest));
            return fu.compose(resourceResponse -> mcpRequest.sender().sendResult(id, resourceResponse), cause -> this.handleFailure(id, mcpRequest.sender(), mcpRequest.connection(), (Throwable)cause, LOG, "Unable to read resource %s", resourceUri));
        }
        catch (McpException e) {
            return mcpRequest.sender().sendError(id, e.getJsonRpcError(), e.getMessage());
        }
    }
}

