/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.mcp.server.CompletionResponse;
import io.quarkiverse.mcp.server.PromptCompletionManager;
import io.quarkiverse.mcp.server.PromptManager;
import io.quarkiverse.mcp.server.runtime.CompletionManagerBase;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.Feature;
import io.quarkiverse.mcp.server.runtime.FeatureArgument;
import io.quarkiverse.mcp.server.runtime.FeatureMetadata;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.McpMetadata;
import io.quarkiverse.mcp.server.runtime.PromptManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResponseHandlers;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.vertx.core.Vertx;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;

@Singleton
public class PromptCompletionManagerImpl
extends CompletionManagerBase
implements PromptCompletionManager {
    private final PromptManagerImpl promptManager;

    protected PromptCompletionManagerImpl(McpMetadata metadata, Vertx vertx, ObjectMapper mapper, ConnectionManager connectionManager, PromptManagerImpl promptManager, Instance<CurrentIdentityAssociation> currentIdentityAssociation, ResponseHandlers responseHandlers) {
        super(vertx, mapper, connectionManager, currentIdentityAssociation, responseHandlers);
        this.promptManager = promptManager;
        for (FeatureMetadata<CompletionResponse> c : metadata.promptCompletions()) {
            String key = c.info().name() + "_" + c.info().arguments().stream().filter(FeatureArgument::isParam).findFirst().orElseThrow().name();
            this.completions.put(key, new CompletionManagerBase.CompletionMethod(c));
        }
    }

    @Override
    protected McpException notFound(String id) {
        return new McpException("Prompt completion does not exist: " + id, -32602);
    }

    @Override
    protected Feature feature() {
        return Feature.PROMPT_COMPLETE;
    }

    @Override
    protected void validateReference(String refName, String argumentName) {
        PromptManager.PromptInfo prompt = this.promptManager.getPrompt(refName);
        if (prompt == null) {
            throw new IllegalStateException("Prompt does not exist: " + refName);
        }
        for (PromptManager.PromptArgument a : prompt.arguments()) {
            if (!a.name().equals(argumentName)) continue;
            return;
        }
        throw new IllegalStateException("Prompt [" + refName + "] does not define argument: " + argumentName);
    }
}

