/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.ProgressNotification;
import io.quarkiverse.mcp.server.ProgressToken;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.Sender;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.math.BigDecimal;
import java.util.Objects;

class ProgressNotificationImpl
implements ProgressNotification {
    private final Sender sender;
    private final ProgressToken token;
    private final BigDecimal total;
    private final BigDecimal progress;
    private final String message;

    public ProgressNotificationImpl(Sender sender, ProgressToken token, BigDecimal total, BigDecimal progress, String message) {
        this.sender = Objects.requireNonNull(sender);
        this.token = Objects.requireNonNull(token);
        this.progress = Objects.requireNonNull(progress);
        this.total = total;
        this.message = message;
    }

    @Override
    public ProgressToken token() {
        return this.token;
    }

    @Override
    public BigDecimal total() {
        return this.total;
    }

    @Override
    public BigDecimal progress() {
        return this.progress;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public void sendAndForget() {
        this.doSend();
    }

    @Override
    public Uni<Void> send() {
        return Uni.createFrom().completionStage(() -> this.doSend().toCompletionStage());
    }

    private Future<Void> doSend() {
        JsonObject notification = new JsonObject().put("progressToken", this.token.value());
        this.putDecimal(notification, "progress", this.progress);
        if (this.total != null) {
            this.putDecimal(notification, "total", this.total);
        }
        if (this.message != null) {
            notification.put("message", (Object)this.message);
        }
        return this.sender.send(Messages.newNotification("notifications/progress", notification));
    }

    private void putDecimal(JsonObject obj, String name, BigDecimal value) {
        if (value.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0) {
            obj.put(name, (Object)value);
        } else {
            obj.put(name, (Object)value.doubleValue());
        }
    }
}

