/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.Progress;
import io.quarkiverse.mcp.server.ProgressNotification;
import io.quarkiverse.mcp.server.ProgressToken;
import io.quarkiverse.mcp.server.ProgressTracker;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.ProgressNotificationImpl;
import io.quarkiverse.mcp.server.runtime.ProgressTrackerImpl;
import io.quarkiverse.mcp.server.runtime.Sender;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.function.Function;

class ProgressImpl
implements Progress {
    private final Optional<ProgressToken> token;
    private final Sender sender;

    static ProgressImpl from(ArgumentProviders argProviders) {
        ProgressToken token = null;
        if (argProviders.progressToken() != null) {
            token = new ProgressToken(argProviders.progressToken());
        }
        return new ProgressImpl(token, argProviders.sender());
    }

    ProgressImpl(ProgressToken token, Sender sender) {
        this.token = Optional.ofNullable(token);
        this.sender = sender;
    }

    @Override
    public Optional<ProgressToken> token() {
        return this.token;
    }

    @Override
    public ProgressNotification.Builder notificationBuilder() {
        if (this.token.isEmpty()) {
            throw new IllegalStateException("Token not present");
        }
        return new NotificationBuilder();
    }

    @Override
    public ProgressTracker.Builder trackerBuilder() {
        if (this.token.isEmpty()) {
            throw new IllegalStateException("Token not present");
        }
        return new TrackerBuilder();
    }

    class NotificationBuilder
    implements ProgressNotification.Builder {
        private BigDecimal total;
        private BigDecimal progress;
        private String message;

        NotificationBuilder() {
        }

        @Override
        public ProgressNotification.Builder setProgress(long progress) {
            this.progress = new BigDecimal(progress);
            return this;
        }

        @Override
        public ProgressNotification.Builder setProgress(double progress) {
            this.progress = new BigDecimal(progress);
            return this;
        }

        @Override
        public ProgressNotification.Builder setTotal(long total) {
            this.total = new BigDecimal(total);
            return this;
        }

        @Override
        public ProgressNotification.Builder setTotal(double total) {
            this.total = new BigDecimal(total);
            return this;
        }

        @Override
        public ProgressNotification.Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        @Override
        public ProgressNotification build() {
            return new ProgressNotificationImpl(ProgressImpl.this.sender, ProgressImpl.this.token.get(), this.total, this.progress, this.message);
        }
    }

    class TrackerBuilder
    implements ProgressTracker.Builder {
        private BigDecimal total;
        private BigDecimal step;
        private Function<BigDecimal, String> messageBuilder;

        TrackerBuilder() {
        }

        @Override
        public ProgressTracker.Builder setTotal(long total) {
            this.total = new BigDecimal(total);
            return this;
        }

        @Override
        public ProgressTracker.Builder setTotal(double total) {
            this.total = new BigDecimal(total);
            return this;
        }

        @Override
        public ProgressTracker.Builder setDefaultStep(long step) {
            this.step = new BigDecimal(step);
            return this;
        }

        @Override
        public ProgressTracker.Builder setDefaultStep(double step) {
            this.step = new BigDecimal(step);
            return this;
        }

        @Override
        public ProgressTracker.Builder setMessageBuilder(Function<BigDecimal, String> messageBuilder) {
            this.messageBuilder = messageBuilder;
            return this;
        }

        @Override
        public ProgressTracker build() {
            return new ProgressTrackerImpl(ProgressImpl.this.sender, ProgressImpl.this.token.get(), this.total, this.step, this.messageBuilder);
        }
    }
}

