/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.McpLog;
import io.quarkiverse.mcp.server.runtime.Cursor;
import io.quarkiverse.mcp.server.runtime.Sender;
import io.vertx.core.json.JsonObject;
import org.jboss.logging.Logger;

public class Messages {
    private static final Logger LOG = Logger.getLogger(Messages.class);

    public static JsonObject newResult(Object id, Object result) {
        JsonObject response = new JsonObject();
        response.put("jsonrpc", (Object)"2.0");
        response.put("id", id);
        response.put("result", result);
        return response;
    }

    public static JsonObject newError(Object id, int code, String message) {
        JsonObject response = new JsonObject();
        response.put("jsonrpc", (Object)"2.0");
        response.put("id", id);
        response.put("error", (Object)new JsonObject().put("code", (Object)code).put("message", (Object)message));
        return response;
    }

    public static JsonObject newNotification(String method, Object params) {
        JsonObject ret = new JsonObject().put("jsonrpc", (Object)"2.0").put("method", (Object)method);
        if (params != null) {
            ret.put("params", params);
        }
        return ret;
    }

    public static JsonObject newNotification(String method) {
        return Messages.newNotification(method, null);
    }

    public static JsonObject newPing(Object id) {
        return Messages.newRequest(id, "ping");
    }

    public static JsonObject newRequest(Object id, String method) {
        return Messages.newRequest(id, method, null);
    }

    public static JsonObject newRequest(Object id, String method, Object params) {
        JsonObject request = new JsonObject();
        request.put("jsonrpc", (Object)"2.0");
        request.put("id", id);
        request.put("method", (Object)method);
        if (params != null) {
            request.put("params", params);
        }
        return request;
    }

    public static boolean isResponse(JsonObject message) {
        return message.containsKey("result") || message.containsKey("error");
    }

    public static boolean isRequest(JsonObject message) {
        return !Messages.isResponse(message) && message.getValue("id") != null;
    }

    public static boolean isNotification(JsonObject message) {
        return !Messages.isResponse(message) && message.getValue("id") == null;
    }

    static Cursor getCursor(JsonObject message, Sender sender) {
        String cursorVal;
        JsonObject params = message.getJsonObject("params");
        if (params != null && (cursorVal = params.getString("cursor")) != null) {
            try {
                return Cursor.decode(cursorVal);
            }
            catch (Exception e) {
                LOG.warnf("Invalid cursor detected %s: %s", (Object)cursorVal, (Object)e.toString());
                sender.sendError(message.getValue("id"), -32602, "Invalid cursor detected: " + cursorVal);
                return null;
            }
        }
        return Cursor.FIRST_PAGE;
    }

    static Object getProgressToken(JsonObject message) {
        JsonObject meta;
        JsonObject params = message.getJsonObject("params");
        if (params != null && (meta = params.getJsonObject("_meta")) != null) {
            return meta.getValue("progressToken");
        }
        return null;
    }

    public static JsonObject newLog(McpLog.LogLevel level, String loggerName, Object data) {
        return new JsonObject().put("level", (Object)level.toString().toLowerCase()).put("logger", (Object)loggerName).put("data", data);
    }
}

