/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.Cancellation;
import io.quarkiverse.mcp.server.McpConnection;
import io.quarkiverse.mcp.server.runtime.Failures;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.Sender;
import io.vertx.core.Future;
import org.jboss.logging.Logger;

public abstract class MessageHandler {
    private static final Logger LOG = Logger.getLogger(MessageHandler.class);

    protected Future<Void> handleFailure(Object requestId, Sender sender, McpConnection connection, Throwable cause, Logger logger, String errorMessage, String featureId) {
        if (cause instanceof McpException) {
            McpException mcp = (McpException)cause;
            return sender.sendError(requestId, mcp.getJsonRpcError(), mcp.getMessage());
        }
        if (cause instanceof Cancellation.OperationCancellationException) {
            LOG.debugf("Operation for request %s was cancelled", requestId);
            return Future.succeededFuture();
        }
        if (Failures.isSecurityFailure(cause)) {
            return sender.sendError(requestId, -32001, cause.toString());
        }
        logger.errorf(cause, errorMessage, (Object)featureId);
        return sender.sendInternalError(requestId);
    }
}

