/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.runtime.ContextSupport;
import io.quarkiverse.mcp.server.runtime.McpConnectionBase;
import io.quarkiverse.mcp.server.runtime.SecuritySupport;
import io.quarkiverse.mcp.server.runtime.Sender;
import io.vertx.core.json.JsonObject;

public interface McpRequest {
    public String serverName();

    public Object json();

    public McpConnectionBase connection();

    public Sender sender();

    public SecuritySupport securitySupport();

    public ContextSupport contextSupport();

    default public void messageReceived(JsonObject message) {
        if (this.connection().trafficLogger() != null) {
            this.connection().trafficLogger().messageReceived(message, this.connection());
        }
    }

    default public void messageSent(JsonObject message) {
        if (this.connection().trafficLogger() != null) {
            this.connection().trafficLogger().messageSent(message, this.connection());
        }
    }

    public void contextStart();

    public void contextEnd();
}

