/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.ClientCapability;
import io.quarkiverse.mcp.server.FeatureManager;
import io.quarkiverse.mcp.server.Implementation;
import io.quarkiverse.mcp.server.InitialCheck;
import io.quarkiverse.mcp.server.InitialRequest;
import io.quarkiverse.mcp.server.McpConnection;
import io.quarkiverse.mcp.server.McpLog;
import io.quarkiverse.mcp.server.Notification;
import io.quarkiverse.mcp.server.NotificationManager;
import io.quarkiverse.mcp.server.RequestId;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.FeatureManagerBase;
import io.quarkiverse.mcp.server.runtime.JsonRPC;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.McpMetadata;
import io.quarkiverse.mcp.server.runtime.McpRequest;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.NotificationManagerImpl;
import io.quarkiverse.mcp.server.runtime.PromptCompleteMessageHandler;
import io.quarkiverse.mcp.server.runtime.PromptCompletionManagerImpl;
import io.quarkiverse.mcp.server.runtime.PromptManagerImpl;
import io.quarkiverse.mcp.server.runtime.PromptMessageHandler;
import io.quarkiverse.mcp.server.runtime.ResourceManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceMessageHandler;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateCompleteMessageHandler;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateCompletionManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateMessageHandler;
import io.quarkiverse.mcp.server.runtime.ResponseHandlers;
import io.quarkiverse.mcp.server.runtime.ToolManagerImpl;
import io.quarkiverse.mcp.server.runtime.ToolMessageHandler;
import io.quarkiverse.mcp.server.runtime.config.McpServerRuntimeConfig;
import io.quarkiverse.mcp.server.runtime.config.McpServersRuntimeConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public abstract class McpMessageHandler<MCP_REQUEST extends McpRequest> {
    private static final Logger LOG = Logger.getLogger(McpMessageHandler.class);
    protected final ConnectionManager connectionManager;
    protected final PromptManagerImpl promptManager;
    protected final ToolManagerImpl toolManager;
    protected final ResourceManagerImpl resourceManager;
    protected final PromptCompletionManagerImpl promptCompletionManager;
    protected final ResourceTemplateManagerImpl resourceTemplateManager;
    protected final ResourceTemplateCompletionManagerImpl resourceTemplateCompletionManager;
    protected final NotificationManagerImpl notificationManager;
    private final ToolMessageHandler toolHandler;
    private final PromptMessageHandler promptHandler;
    private final PromptCompleteMessageHandler promptCompleteHandler;
    private final ResourceMessageHandler resourceHandler;
    private final ResourceTemplateMessageHandler resourceTemplateHandler;
    private final ResourceTemplateCompleteMessageHandler resourceTemplateCompleteHandler;
    private final ResponseHandlers responseHandlers;
    private final List<InitialCheck> initialChecks;
    protected final McpServersRuntimeConfig config;
    protected final Vertx vertx;
    private final Set<String> ongoingRequests;
    private final McpMetadata metadata;
    public static final String INITIALIZE = "initialize";
    public static final String NOTIFICATIONS_INITIALIZED = "notifications/initialized";
    public static final String NOTIFICATIONS_MESSAGE = "notifications/message";
    public static final String NOTIFICATIONS_PROGRESS = "notifications/progress";
    public static final String NOTIFICATIONS_CANCELLED = "notifications/cancelled";
    public static final String NOTIFICATIONS_TOOLS_LIST_CHANGED = "notifications/tools/list_changed";
    public static final String NOTIFICATIONS_RESOURCES_LIST_CHANGED = "notifications/resources/list_changed";
    public static final String NOTIFICATIONS_PROMPTS_LIST_CHANGED = "notifications/prompts/list_changed";
    public static final String NOTIFICATIONS_ROOTS_LIST_CHANGED = "notifications/roots/list_changed";
    public static final String PROMPTS_LIST = "prompts/list";
    public static final String PROMPTS_GET = "prompts/get";
    public static final String TOOLS_LIST = "tools/list";
    public static final String TOOLS_CALL = "tools/call";
    public static final String RESOURCES_LIST = "resources/list";
    public static final String RESOURCE_TEMPLATES_LIST = "resources/templates/list";
    public static final String RESOURCES_READ = "resources/read";
    public static final String RESOURCES_SUBSCRIBE = "resources/subscribe";
    public static final String RESOURCES_UNSUBSCRIBE = "resources/unsubscribe";
    public static final String PING = "ping";
    public static final String ROOTS_LIST = "roots/list";
    public static final String SAMPLING_CREATE_MESSAGE = "sampling/createMessage";
    public static final String COMPLETION_COMPLETE = "completion/complete";
    public static final String LOGGING_SET_LEVEL = "logging/setLevel";
    public static final String Q_CLOSE = "q/close";
    private static final List<String> SUPPORTED_PROTOCOL_VERSIONS = List.of("2025-03-26", "2024-11-05");

    protected McpMessageHandler(McpServersRuntimeConfig config, ConnectionManager connectionManager, PromptManagerImpl promptManager, ToolManagerImpl toolManager, ResourceManagerImpl resourceManager, PromptCompletionManagerImpl promptCompletionManager, ResourceTemplateManagerImpl resourceTemplateManager, ResourceTemplateCompletionManagerImpl resourceTemplateCompletionManager, NotificationManagerImpl notificationManager, ResponseHandlers responseHandlers, McpMetadata metadata, Vertx vertx, List<InitialCheck> initialChecks) {
        this.connectionManager = connectionManager;
        this.promptManager = promptManager;
        this.toolManager = toolManager;
        this.resourceManager = resourceManager;
        this.resourceTemplateManager = resourceTemplateManager;
        this.promptCompletionManager = promptCompletionManager;
        this.resourceTemplateCompletionManager = resourceTemplateCompletionManager;
        this.toolHandler = new ToolMessageHandler(toolManager, config);
        this.promptHandler = new PromptMessageHandler(promptManager, config);
        this.promptCompleteHandler = new PromptCompleteMessageHandler(promptCompletionManager);
        this.resourceHandler = new ResourceMessageHandler(resourceManager, config);
        this.resourceTemplateHandler = new ResourceTemplateMessageHandler(resourceTemplateManager, config);
        this.resourceTemplateCompleteHandler = new ResourceTemplateCompleteMessageHandler(resourceTemplateCompletionManager);
        this.notificationManager = notificationManager;
        this.responseHandlers = responseHandlers;
        this.initialChecks = initialChecks;
        this.config = config;
        this.metadata = metadata;
        this.vertx = vertx;
        this.ongoingRequests = ConcurrentHashMap.newKeySet();
        if (config.invalidServerNameStrategy() == McpServersRuntimeConfig.InvalidServerNameStrategy.FAIL) {
            this.validateServerConfigs();
        }
    }

    public Future<?> handle(MCP_REQUEST mcpRequest) {
        JsonArray batch;
        Object json = mcpRequest.json();
        if (json instanceof JsonObject) {
            JsonObject message = (JsonObject)json;
            mcpRequest.messageReceived(message);
            if (JsonRPC.validate(message, mcpRequest.sender())) {
                return Messages.isResponse(message) ? this.handleResponse(message) : this.handleRequest(message, mcpRequest);
            }
            this.jsonrpcValidationFailed(mcpRequest);
        } else if (json instanceof JsonArray && !(batch = (JsonArray)json).isEmpty()) {
            ArrayList<Future<Void>> all = new ArrayList<Future<Void>>();
            if (Messages.isResponse(batch.getJsonObject(0))) {
                for (Object e : batch) {
                    JsonObject response = (JsonObject)e;
                    mcpRequest.messageReceived(response);
                    if (JsonRPC.validate(response, mcpRequest.sender())) {
                        all.add(this.handleResponse(response));
                        continue;
                    }
                    this.jsonrpcValidationFailed(mcpRequest);
                }
            } else {
                for (Object e : batch) {
                    JsonObject requestOrNotification = (JsonObject)e;
                    mcpRequest.messageReceived(requestOrNotification);
                    if (JsonRPC.validate(requestOrNotification, mcpRequest.sender())) {
                        all.add(this.handleRequest(requestOrNotification, mcpRequest));
                        continue;
                    }
                    this.jsonrpcValidationFailed(mcpRequest);
                }
            }
            return Future.all(all);
        }
        return Future.failedFuture((String)"Invalid jsonrpc message");
    }

    protected void jsonrpcValidationFailed(MCP_REQUEST mcpRequest) {
    }

    protected void initializeFailed(MCP_REQUEST mcpRequest) {
    }

    protected void afterInitialize(MCP_REQUEST mcpRequest) {
    }

    protected abstract InitialRequest.Transport transport();

    private Future<Void> handleResponse(JsonObject message) {
        return this.responseHandlers.handleResponse(message.getValue("id"), message);
    }

    private Future<Void> handleRequest(JsonObject message, MCP_REQUEST mcpRequest) {
        return switch (mcpRequest.connection().status()) {
            default -> throw new IncompatibleClassChangeError();
            case McpConnection.Status.NEW -> this.initializeNew(message, mcpRequest);
            case McpConnection.Status.INITIALIZING -> this.initializing(message, (McpRequest)mcpRequest);
            case McpConnection.Status.IN_OPERATION -> this.operation(message, (McpRequest)mcpRequest);
            case McpConnection.Status.CLOSED -> mcpRequest.sender().send(Messages.newError(message.getValue("id"), -32603, "Connection is closed"));
        };
    }

    private McpServerRuntimeConfig serverConfig(MCP_REQUEST mcpRequest) {
        McpServerRuntimeConfig serverConfig = this.config.servers().get(mcpRequest.serverName());
        if (serverConfig == null) {
            throw new IllegalStateException("Server config not found: " + mcpRequest.serverName());
        }
        return serverConfig;
    }

    private Future<Void> initializeNew(JsonObject message, MCP_REQUEST mcpRequest) {
        Object id = message.getValue("id");
        String method = message.getString("method");
        JsonObject params = message.getJsonObject("params");
        if (!INITIALIZE.equals(method)) {
            if (LaunchMode.current() == LaunchMode.DEVELOPMENT && this.serverConfig(mcpRequest).devMode().dummyInit()) {
                InitialRequest dummy = new InitialRequest(new Implementation("dummy", "1"), SUPPORTED_PROTOCOL_VERSIONS.get(0), List.of(), this.transport());
                if (mcpRequest.connection().initialize(dummy) && mcpRequest.connection().setInitialized()) {
                    LOG.infof("Connection initialized with dummy info [%s]", (Object)mcpRequest.connection().id());
                    return this.operation(message, (McpRequest)mcpRequest);
                }
            }
            String msg = "The first message from the client must be \"initialize\": " + method;
            this.initializeFailed(mcpRequest);
            return mcpRequest.sender().sendError(id, -32601, msg);
        }
        if (params == null) {
            String msg = "Initialization params not found";
            this.initializeFailed(mcpRequest);
            return mcpRequest.sender().sendError(id, -32602, msg);
        }
        InitialRequest initialRequest = this.decodeInitializeRequest(params);
        mcpRequest.contextStart();
        return UniHelper.toFuture(McpMessageHandler.checkInit(initialRequest, this.initialChecks, 0)).compose(res -> {
            if (res.error()) {
                this.initializeFailed(mcpRequest);
                return mcpRequest.sender().sendError(id, -32603, res.message());
            }
            if (mcpRequest.connection().initialize(initialRequest)) {
                this.afterInitialize(mcpRequest);
                return mcpRequest.sender().sendResult(id, this.serverInfo(mcpRequest, initialRequest));
            }
            this.initializeFailed(mcpRequest);
            String msg = "Unable to initialize connection [connectionId: " + mcpRequest.connection().id() + "]";
            return mcpRequest.sender().sendError(id, -32603, msg);
        }).onComplete(r -> mcpRequest.contextEnd());
    }

    private static Uni<InitialCheck.CheckResult> checkInit(InitialRequest initialRequest, List<InitialCheck> checks, int idx) {
        if (checks.isEmpty()) {
            return InitialCheck.CheckResult.successs();
        }
        try {
            return checks.get(idx).perform(initialRequest).chain(res -> {
                if (idx < checks.size() - 1 && !res.error()) {
                    return McpMessageHandler.checkInit(initialRequest, checks, idx + 1);
                }
                return Uni.createFrom().item(res);
            });
        }
        catch (Throwable t) {
            return Uni.createFrom().failure(t);
        }
    }

    private Future<Void> initializing(JsonObject message, McpRequest mcpRequest) {
        String method = message.getString("method");
        if (NOTIFICATIONS_INITIALIZED.equals(method)) {
            if (mcpRequest.connection().setInitialized()) {
                LOG.debugf("Client successfully initialized [%s]", (Object)mcpRequest.connection().id());
                List<NotificationManager.NotificationInfo> infos = this.notificationManager.infosForRequest(mcpRequest).filter(n -> n.type() == Notification.Type.INITIALIZED).toList();
                if (!infos.isEmpty()) {
                    ArgumentProviders argProviders = new ArgumentProviders(Map.of(), mcpRequest.connection(), null, null, mcpRequest.sender(), null, this.responseHandlers, mcpRequest.serverName());
                    FeatureManagerBase.FeatureExecutionContext featureExecutionContext = new FeatureManagerBase.FeatureExecutionContext(argProviders, mcpRequest);
                    for (final NotificationManager.NotificationInfo notification : infos) {
                        try {
                            Future fu = this.notificationManager.execute(this.notificationManager.key(notification), featureExecutionContext);
                            fu.onComplete((Handler)new Handler<AsyncResult<Void>>(){

                                public void handle(AsyncResult<Void> ar) {
                                    if (ar.failed()) {
                                        LOG.errorf(ar.cause(), "Unable to call notification method: %s", (Object)notification);
                                    }
                                }
                            });
                        }
                        catch (McpException e) {
                            LOG.errorf((Throwable)e, "Unable to call notification method: %s", (Object)notification);
                        }
                    }
                }
            }
            return Future.succeededFuture();
        }
        if (PING.equals(method)) {
            return this.ping(message, mcpRequest);
        }
        return mcpRequest.sender().send(Messages.newError(message.getValue("id"), -32603, "Client not initialized yet [" + mcpRequest.connection().id() + "]"));
    }

    private Future<Void> operation(JsonObject message, McpRequest mcpRequest) {
        Context context = VertxContext.createNewDuplicatedContext((Context)this.vertx.getOrCreateContext());
        VertxContextSafetyToggle.setContextSafe((Context)context, (boolean)true);
        Promise ret = Promise.promise();
        String ongoingId = this.ongoingId(message, mcpRequest);
        if (ongoingId != null) {
            this.ongoingRequests.add(ongoingId);
        }
        context.runOnContext(v -> {
            String method;
            mcpRequest.contextStart();
            Future<Void> future = switch (method = message.getString("method")) {
                case PROMPTS_LIST -> this.promptHandler.promptsList(message, mcpRequest);
                case PROMPTS_GET -> this.promptHandler.promptsGet(message, mcpRequest);
                case TOOLS_LIST -> this.toolHandler.toolsList(message, mcpRequest);
                case TOOLS_CALL -> this.toolHandler.toolsCall(message, mcpRequest);
                case PING -> this.ping(message, mcpRequest);
                case RESOURCES_LIST -> this.resourceHandler.resourcesList(message, mcpRequest);
                case RESOURCES_READ -> this.resourceHandler.resourcesRead(message, mcpRequest);
                case RESOURCES_SUBSCRIBE -> this.resourceHandler.resourcesSubscribe(message, mcpRequest);
                case RESOURCES_UNSUBSCRIBE -> this.resourceHandler.resourcesUnsubscribe(message, mcpRequest);
                case RESOURCE_TEMPLATES_LIST -> this.resourceTemplateHandler.resourceTemplatesList(message, mcpRequest);
                case COMPLETION_COMPLETE -> this.complete(message, mcpRequest);
                case LOGGING_SET_LEVEL -> this.setLogLevel(message, mcpRequest);
                case Q_CLOSE -> this.close(message, mcpRequest);
                case NOTIFICATIONS_ROOTS_LIST_CHANGED -> this.rootsListChanged(mcpRequest);
                case NOTIFICATIONS_CANCELLED -> this.cancelRequest(message, mcpRequest);
                default -> mcpRequest.sender().send(Messages.newError(message.getValue("id"), -32601, "Unsupported method: " + method));
            };
            future.onComplete(r -> {
                mcpRequest.contextEnd();
                if (ongoingId != null) {
                    this.ongoingRequests.remove(ongoingId);
                    mcpRequest.connection().removeCancellationRequest(message);
                }
                if (r.failed()) {
                    ret.fail(r.cause());
                } else {
                    ret.complete();
                }
            });
        });
        return ret.future();
    }

    private Future<Void> rootsListChanged(McpRequest mcpRequest) {
        List<NotificationManager.NotificationInfo> infos = this.notificationManager.infosForRequest(mcpRequest).filter(n -> n.type() == Notification.Type.ROOTS_LIST_CHANGED).toList();
        if (!infos.isEmpty()) {
            ArgumentProviders argProviders = new ArgumentProviders(Map.of(), mcpRequest.connection(), null, null, mcpRequest.sender(), null, this.responseHandlers, mcpRequest.serverName());
            FeatureManagerBase.FeatureExecutionContext featureExecutionContext = new FeatureManagerBase.FeatureExecutionContext(argProviders, mcpRequest);
            for (final NotificationManager.NotificationInfo notification : infos) {
                try {
                    Future fu = this.notificationManager.execute(this.notificationManager.key(notification), featureExecutionContext);
                    fu.onComplete((Handler)new Handler<AsyncResult<Void>>(){

                        public void handle(AsyncResult<Void> ar) {
                            if (ar.failed()) {
                                LOG.errorf(ar.cause(), "Unable to call notification method: %s", (Object)notification);
                            }
                        }
                    });
                }
                catch (McpException e) {
                    LOG.errorf((Throwable)e, "Unable to call notification method: %s", (Object)notification);
                }
            }
        }
        return Future.succeededFuture();
    }

    private Future<Void> cancelRequest(JsonObject message, McpRequest mcpRequest) {
        Object requestId;
        JsonObject params = message.getJsonObject("params");
        if (params != null && (requestId = params.getValue("requestId")) != null && this.ongoingRequests.contains(this.ongoingId(requestId, mcpRequest))) {
            String reason = params.getString("reason");
            LOG.debugf("Cancel request with id %s: %s [%s]", requestId, (Object)(reason != null ? reason : "no reason"), (Object)mcpRequest.connection().id());
            mcpRequest.connection().addCancellationRequest(new RequestId(requestId), reason);
        }
        return Future.succeededFuture();
    }

    private String ongoingId(JsonObject message, McpRequest mcpRequest) {
        return this.ongoingId(Messages.isRequest(message) ? message.getValue("id") : null, mcpRequest);
    }

    private String ongoingId(Object requestId, McpRequest mcpRequest) {
        if (requestId != null) {
            return String.valueOf(requestId) + "::" + mcpRequest.connection().id();
        }
        return null;
    }

    private Future<Void> setLogLevel(JsonObject message, McpRequest mcpRequest) {
        Object id = message.getValue("id");
        JsonObject params = message.getJsonObject("params");
        String level = params.getString("level");
        if (level == null) {
            return mcpRequest.sender().sendError(id, -32600, "Log level not set");
        }
        McpLog.LogLevel logLevel = McpLog.LogLevel.from(level);
        if (logLevel == null) {
            return mcpRequest.sender().sendError(id, -32600, "Invalid log level set: " + level);
        }
        mcpRequest.connection().setLogLevel(logLevel);
        return mcpRequest.sender().sendResult(id, new JsonObject());
    }

    private Future<Void> complete(JsonObject message, McpRequest mcpRequest) {
        Object id = message.getValue("id");
        JsonObject params = message.getJsonObject("params");
        JsonObject ref = params.getJsonObject("ref");
        if (ref == null) {
            return mcpRequest.sender().sendError(id, -32600, "Reference not found");
        }
        String referenceType = ref.getString("type");
        if (referenceType == null) {
            return mcpRequest.sender().sendError(id, -32600, "Reference type not found");
        }
        JsonObject argument = params.getJsonObject("argument");
        if (argument == null) {
            return mcpRequest.sender().sendError(id, -32600, "Argument not found");
        }
        if ("ref/prompt".equals(referenceType)) {
            return this.promptCompleteHandler.complete(message, id, ref, argument, mcpRequest.sender(), mcpRequest);
        }
        if ("ref/resource".equals(referenceType)) {
            return this.resourceTemplateCompleteHandler.complete(message, id, ref, argument, mcpRequest.sender(), mcpRequest);
        }
        return mcpRequest.sender().sendError(id, -32600, "Unsupported reference found: " + ref.getString("type"));
    }

    private Future<Void> ping(JsonObject message, McpRequest mcpRequest) {
        Object id = message.getValue("id");
        LOG.debugf("Ping [id: %s]", id);
        return mcpRequest.sender().sendResult(id, new JsonObject());
    }

    private Future<Void> close(JsonObject message, McpRequest mcpRequest) {
        if (this.connectionManager.remove(mcpRequest.connection().id())) {
            LOG.debugf("Connection %s explicitly closed ", (Object)mcpRequest.connection().id());
            return Future.succeededFuture();
        }
        return mcpRequest.sender().sendError(message.getValue("id"), -32603, "Unable to obtain the connection to be closed:" + mcpRequest.connection().id());
    }

    private InitialRequest decodeInitializeRequest(JsonObject params) {
        JsonObject clientInfo = params.getJsonObject("clientInfo");
        Implementation implementation = new Implementation(clientInfo.getString("name"), clientInfo.getString("version"));
        String protocolVersion = params.getString("protocolVersion");
        ArrayList<ClientCapability> clientCapabilities = new ArrayList<ClientCapability>();
        JsonObject capabilities = params.getJsonObject("capabilities");
        if (capabilities != null) {
            for (String name : capabilities.fieldNames()) {
                clientCapabilities.add(new ClientCapability(name, Map.of()));
            }
        }
        return new InitialRequest(implementation, protocolVersion, List.copyOf(clientCapabilities), this.transport());
    }

    private Map<String, Object> serverInfo(MCP_REQUEST mcpRequest, InitialRequest initialRequest) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        String version = SUPPORTED_PROTOCOL_VERSIONS.get(0);
        if (SUPPORTED_PROTOCOL_VERSIONS.contains(initialRequest.protocolVersion())) {
            version = initialRequest.protocolVersion();
        }
        info.put("protocolVersion", version);
        String serverName = this.serverConfig(mcpRequest).serverInfo().name().orElse(ConfigProvider.getConfig().getOptionalValue("quarkus.application.name", String.class).orElse("N/A"));
        String serverVersion = this.serverConfig(mcpRequest).serverInfo().version().orElse(ConfigProvider.getConfig().getOptionalValue("quarkus.application.version", String.class).orElse("N/A"));
        info.put("serverInfo", Map.of("name", serverName, "version", serverVersion));
        HashMap capabilities = new HashMap();
        if (this.promptManager.hasInfos((McpRequest)mcpRequest)) {
            capabilities.put("prompts", this.metadata.isPromptManagerUsed() ? Map.of("listChanged", true) : Map.of());
        }
        if (this.toolManager.hasInfos((McpRequest)mcpRequest)) {
            capabilities.put("tools", this.metadata.isToolManagerUsed() ? Map.of("listChanged", true) : Map.of());
        }
        if (this.resourceManager.hasInfos((McpRequest)mcpRequest) || this.resourceTemplateManager.hasInfos((McpRequest)mcpRequest)) {
            capabilities.put("resources", this.metadata.isResourceManagerUsed() ? Map.of("listChanged", true) : Map.of());
        }
        if (this.promptCompletionManager.hasInfos((McpRequest)mcpRequest) || this.resourceTemplateCompletionManager.hasInfos((McpRequest)mcpRequest)) {
            capabilities.put("completions", Map.of());
        }
        capabilities.put("logging", Map.of());
        info.put("capabilities", capabilities);
        return info;
    }

    private void validateServerConfigs() {
        ArrayList<FeatureManager.FeatureInfo> invalid = new ArrayList<FeatureManager.FeatureInfo>();
        HashSet<String> serverNames = new HashSet<String>(this.metadata.serverNames());
        serverNames.addAll(this.config.servers().keySet());
        for (FeatureManager.FeatureInfo info : this.toolManager) {
            if (serverNames.contains(info.serverName())) continue;
            invalid.add(info);
        }
        for (FeatureManager.FeatureInfo info : this.promptManager) {
            if (serverNames.contains(info.serverName())) continue;
            invalid.add(info);
        }
        for (FeatureManager.FeatureInfo info : this.resourceManager) {
            if (serverNames.contains(info.serverName())) continue;
            invalid.add(info);
        }
        for (FeatureManager.FeatureInfo info : this.resourceTemplateManager) {
            if (serverNames.contains(info.serverName())) continue;
            invalid.add(info);
        }
        for (FeatureManager.FeatureInfo info : this.notificationManager) {
            if (serverNames.contains(info.serverName())) continue;
            invalid.add(info);
        }
        for (FeatureManager.FeatureInfo info : this.promptCompletionManager) {
            if (serverNames.contains(info.serverName())) continue;
            invalid.add(info);
        }
        for (FeatureManager.FeatureInfo info : this.resourceTemplateCompletionManager) {
            if (serverNames.contains(info.serverName())) continue;
            invalid.add(info);
        }
        if (!invalid.isEmpty()) {
            IllegalStateException ise = new IllegalStateException("Invalid server name");
            for (FeatureManager.FeatureInfo info : invalid) {
                ise.addSuppressed(new IllegalStateException(String.format("Invalid server name [%s] used for: %s", info.serverName(), info)));
            }
            throw ise;
        }
    }
}

