/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.McpLog;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.Sender;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

class McpLogImpl
implements McpLog {
    private final String mcpLoggerName;
    private final Supplier<McpLog.LogLevel> level;
    private final Logger logger;
    private final Sender sender;

    McpLogImpl(Supplier<McpLog.LogLevel> level, Logger logger, String mcpLoggerName, Sender sender) {
        this.mcpLoggerName = mcpLoggerName;
        this.level = level;
        this.logger = logger;
        this.sender = sender;
    }

    @Override
    public void send(McpLog.LogLevel level, Object data) {
        if (this.isEnabled(Objects.requireNonNull(level))) {
            this.sender.send(Messages.newNotification("notifications/message", Messages.newLog(level, this.mcpLoggerName, this.encode(data))));
        }
    }

    @Override
    public void send(McpLog.LogLevel level, String format, Object ... params) {
        if (this.isEnabled(Objects.requireNonNull(level))) {
            this.sender.send(Messages.newNotification("notifications/message", Messages.newLog(level, this.mcpLoggerName, format.formatted(params))));
        }
    }

    @Override
    public McpLog.LogLevel level() {
        return this.level.get();
    }

    @Override
    public void info(String format, Object ... params) {
        this.logger.infof(format, params);
        this.send(McpLog.LogLevel.INFO, format, params);
    }

    @Override
    public void debug(String format, Object ... params) {
        this.logger.debugf(format, params);
        this.send(McpLog.LogLevel.DEBUG, format, params);
    }

    @Override
    public void error(String format, Object ... params) {
        this.logger.errorf(format, params);
        this.send(McpLog.LogLevel.ERROR, format, params);
    }

    @Override
    public void error(Throwable t, String format, Object ... params) {
        this.logger.infof(t, format, params);
        this.send(McpLog.LogLevel.ERROR, format, params);
    }

    private boolean isEnabled(McpLog.LogLevel level) {
        return this.level().ordinal() <= level.ordinal();
    }

    private Object encode(Object data) {
        if (data instanceof JsonObject || data instanceof JsonArray || data instanceof String) {
            return data;
        }
        return Json.encode((Object)data);
    }
}

