/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import io.quarkiverse.mcp.server.InitialRequest;
import io.quarkiverse.mcp.server.McpConnection;
import io.quarkiverse.mcp.server.McpLog;
import io.quarkiverse.mcp.server.RequestId;
import io.quarkiverse.mcp.server.runtime.Sender;
import io.quarkiverse.mcp.server.runtime.TrafficLogger;
import io.quarkiverse.mcp.server.runtime.config.McpServerRuntimeConfig;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public abstract class McpConnectionBase
implements McpConnection,
Sender {
    protected final String id;
    protected final AtomicReference<McpConnection.Status> status;
    protected final AtomicReference<InitialRequest> initializeRequest;
    protected final AtomicReference<McpLog.LogLevel> logLevel;
    protected final TrafficLogger trafficLogger;
    protected final Optional<Duration> autoPingInterval;
    protected final AtomicLong lastUsed;
    protected final long idleTimeout;
    protected final ConcurrentMap<RequestId, Optional<String>> cancellationRequests;

    protected McpConnectionBase(String id, McpServerRuntimeConfig serverConfig) {
        this.id = id;
        this.status = new AtomicReference<McpConnection.Status>(McpConnection.Status.NEW);
        this.initializeRequest = new AtomicReference();
        this.logLevel = new AtomicReference<McpLog.LogLevel>(serverConfig.clientLogging().defaultLevel());
        this.trafficLogger = serverConfig.trafficLogging().enabled() ? new TrafficLogger(serverConfig.trafficLogging().textLimit()) : null;
        this.autoPingInterval = serverConfig.autoPingInterval();
        this.lastUsed = new AtomicLong(Instant.now().toEpochMilli());
        this.idleTimeout = serverConfig.connectionIdleTimeout().toMillis();
        this.cancellationRequests = new ConcurrentHashMap<RequestId, Optional<String>>();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public McpConnection.Status status() {
        return this.status.get();
    }

    @Override
    public InitialRequest initialRequest() {
        return this.initializeRequest.get();
    }

    public boolean initialize(InitialRequest request) {
        if (this.status.compareAndSet(McpConnection.Status.NEW, McpConnection.Status.INITIALIZING)) {
            this.initializeRequest.set(request);
            return true;
        }
        return false;
    }

    public boolean close() {
        return this.status.compareAndSet(McpConnection.Status.IN_OPERATION, McpConnection.Status.CLOSED);
    }

    @Override
    public McpLog.LogLevel logLevel() {
        return this.logLevel.get();
    }

    void setLogLevel(McpLog.LogLevel level) {
        this.logLevel.set(level);
    }

    public boolean setInitialized() {
        return this.status.compareAndSet(McpConnection.Status.INITIALIZING, McpConnection.Status.IN_OPERATION);
    }

    public TrafficLogger trafficLogger() {
        return this.trafficLogger;
    }

    public Optional<Duration> autoPingInterval() {
        return this.autoPingInterval;
    }

    public McpConnectionBase touch() {
        this.lastUsed.set(Instant.now().toEpochMilli());
        return this;
    }

    public boolean isIdleTimeoutExpired() {
        if (this.idleTimeout <= 0L) {
            return false;
        }
        return Instant.now().minusMillis(this.lastUsed.get()).toEpochMilli() > this.idleTimeout;
    }

    Optional<String> getCancellationRequest(RequestId requestId) {
        return (Optional)this.cancellationRequests.get(requestId);
    }

    void addCancellationRequest(RequestId requestId, String reason) {
        this.cancellationRequests.put(requestId, Optional.ofNullable(reason));
    }

    void removeCancellationRequest(JsonObject request) {
        if (!this.cancellationRequests.isEmpty()) {
            this.cancellationRequests.remove(new RequestId(request.getValue("id")));
        }
    }
}

