/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkiverse.mcp.server.DefaultValueConverter;
import io.quarkiverse.mcp.server.FeatureManager;
import io.quarkiverse.mcp.server.McpConnection;
import io.quarkiverse.mcp.server.McpLog;
import io.quarkiverse.mcp.server.RequestId;
import io.quarkiverse.mcp.server.RequestUri;
import io.quarkiverse.mcp.server.runtime.ArgumentProviders;
import io.quarkiverse.mcp.server.runtime.CancellationImpl;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.Cursor;
import io.quarkiverse.mcp.server.runtime.ExecutionModel;
import io.quarkiverse.mcp.server.runtime.FeatureArgument;
import io.quarkiverse.mcp.server.runtime.FeatureMetadata;
import io.quarkiverse.mcp.server.runtime.McpConnectionBase;
import io.quarkiverse.mcp.server.runtime.McpException;
import io.quarkiverse.mcp.server.runtime.McpLogImpl;
import io.quarkiverse.mcp.server.runtime.McpRequest;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.runtime.Page;
import io.quarkiverse.mcp.server.runtime.ProgressImpl;
import io.quarkiverse.mcp.server.runtime.ResponseHandlers;
import io.quarkiverse.mcp.server.runtime.RootsImpl;
import io.quarkiverse.mcp.server.runtime.SamplingImpl;
import io.quarkiverse.mcp.server.runtime.Types;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.virtual.threads.VirtualThreadsRecorder;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.invoke.Invoker;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jboss.logging.Logger;

public abstract class FeatureManagerBase<RESULT, INFO extends FeatureManager.FeatureInfo> {
    protected final Vertx vertx;
    protected final ObjectMapper mapper;
    protected final ConnectionManager connectionManager;
    protected final ConcurrentMap<String, Logger> loggers;
    protected final CurrentIdentityAssociation currentIdentityAssociation;
    final ResponseHandlers responseHandlers;
    private static volatile Instant lastTimestamp = Instant.EPOCH;

    protected FeatureManagerBase(Vertx vertx, ObjectMapper mapper, ConnectionManager connectionManager, Instance<CurrentIdentityAssociation> currentIdentityAssociation, ResponseHandlers responseHandlers) {
        this.vertx = vertx;
        this.mapper = mapper;
        this.connectionManager = connectionManager;
        this.loggers = new ConcurrentHashMap<String, Logger>();
        this.currentIdentityAssociation = currentIdentityAssociation.isResolvable() ? (CurrentIdentityAssociation)currentIdentityAssociation.get() : null;
        this.responseHandlers = responseHandlers;
    }

    public Future<RESULT> execute(String id, final FeatureExecutionContext executionContext) throws McpException {
        final FeatureInvoker<RESULT> invoker = this.getInvoker(id, executionContext.mcpRequest());
        if (invoker != null) {
            return this.execute(invoker.executionModel(), executionContext, new Callable<Uni<RESULT>>(){

                @Override
                public Uni<RESULT> call() throws Exception {
                    return invoker.call(executionContext.argProviders());
                }
            });
        }
        throw this.notFound(id);
    }

    protected Object wrapResult(Object ret, FeatureMetadata<?> metadata, ArgumentProviders argProviders) {
        return ret;
    }

    public Iterator<INFO> iterator() {
        return this.infos().sorted().iterator();
    }

    public Page<INFO> fetchPage(McpRequest mcpRequest, Cursor cursor, int pageSize) {
        long count = this.infosForRequest(mcpRequest).count();
        if (count == 0L) {
            return Page.empty();
        }
        if (pageSize <= 0 || count <= (long)pageSize) {
            return new Page<INFO>(this.infosForRequest(mcpRequest).sorted().toList(), true);
        }
        List<FeatureManager.FeatureInfo> result = this.infosForRequest(mcpRequest).filter(r -> r.createdAt().isAfter(cursor.createdAt()) && (cursor.name() == null || r.name().compareTo(cursor.name()) > 0)).sorted().limit(pageSize + 1).toList();
        if (result.size() > pageSize) {
            return new Page<FeatureManager.FeatureInfo>(result.subList(0, result.size() - 1), false);
        }
        return new Page<FeatureManager.FeatureInfo>(result, true);
    }

    Stream<INFO> infosForRequest(McpRequest mcpRequest) {
        return this.filter(this.infos().filter(i -> this.matches(i, mcpRequest)), mcpRequest.connection());
    }

    abstract Stream<INFO> infos();

    Stream<INFO> filter(Stream<INFO> infos, McpConnection connection) {
        return infos;
    }

    public boolean hasInfos(McpRequest mcpRequest) {
        return this.infosForRequest(mcpRequest).count() > 0L;
    }

    protected boolean matches(INFO info, McpRequest mcpRequest) {
        return info.serverName().equals(mcpRequest.serverName());
    }

    protected Object[] prepareArguments(FeatureMetadata<?> metadata, ArgumentProviders argProviders) throws McpException {
        if (metadata.info().arguments().isEmpty()) {
            return new Object[0];
        }
        Object[] ret = new Object[metadata.info().arguments().size()];
        int idx = 0;
        for (FeatureArgument arg : metadata.info().arguments()) {
            if (arg.provider() == FeatureArgument.Provider.MCP_CONNECTION) {
                ret[idx] = argProviders.connection();
            } else if (arg.provider() == FeatureArgument.Provider.REQUEST_ID) {
                ret[idx] = new RequestId(argProviders.requestId());
            } else if (arg.provider() == FeatureArgument.Provider.REQUEST_URI) {
                ret[idx] = new RequestUri(argProviders.uri());
            } else if (arg.provider() == FeatureArgument.Provider.MCP_LOG) {
                ret[idx] = this.log(this.logKey(metadata), metadata.info().declaringClassName(), argProviders);
            } else if (arg.provider() == FeatureArgument.Provider.PROGRESS) {
                ret[idx] = ProgressImpl.from(argProviders);
            } else if (arg.provider() == FeatureArgument.Provider.ROOTS) {
                ret[idx] = RootsImpl.from(argProviders);
            } else if (arg.provider() == FeatureArgument.Provider.SAMPLING) {
                ret[idx] = SamplingImpl.from(argProviders);
            } else if (arg.provider() == FeatureArgument.Provider.CANCELLATION) {
                ret[idx] = CancellationImpl.from(argProviders);
            } else {
                Class clazz;
                Type argType;
                Optional<Object> val = argProviders.getArg(arg.name());
                if (val == null && arg.defaultValue() != null) {
                    val = this.convert(arg.defaultValue(), arg.type());
                }
                if (val == null && arg.required()) {
                    throw new McpException("Missing required argument: " + arg.name(), -32602);
                }
                boolean isOptional = Types.isOptional(arg.type());
                Type type = argType = isOptional ? Types.getFirstActualTypeArgument(arg.type()) : arg.type();
                if (val instanceof Map) {
                    Map map = (Map)((Object)val);
                    javaType = this.mapper.getTypeFactory().constructType(argType);
                    val = this.mapper.convertValue((Object)map, javaType);
                } else if (val instanceof List) {
                    List list = (List)((Object)val);
                    javaType = this.mapper.getTypeFactory().constructType(argType);
                    val = this.mapper.convertValue((Object)list, javaType);
                } else if (argType instanceof Class && (clazz = (Class)argType).isEnum()) {
                    val = Enum.valueOf(clazz, ((Object)val).toString());
                } else if (val instanceof Number) {
                    Number num = (Number)((Object)val);
                    val = this.coerceNumber(num, argType);
                }
                if (isOptional) {
                    val = Optional.ofNullable(val);
                }
                ret[idx] = val;
            }
            ++idx;
        }
        return ret;
    }

    private Object coerceNumber(Number num, Type argType) {
        if (Integer.class.equals((Object)argType) || Integer.TYPE.equals(argType)) {
            return num instanceof Integer ? (Number)num : (Number)num.intValue();
        }
        if (Long.class.equals((Object)argType) || Long.TYPE.equals(argType)) {
            return num instanceof Long ? (Number)num : (Number)num.longValue();
        }
        if (Short.class.equals((Object)argType) || Short.TYPE.equals(argType)) {
            return num instanceof Short ? (Number)num : (Number)num.shortValue();
        }
        if (Byte.class.equals((Object)argType) || Byte.TYPE.equals(argType)) {
            return num instanceof Byte ? (Number)num : (Number)num.byteValue();
        }
        if (Float.class.equals((Object)argType) || Float.TYPE.equals(argType)) {
            return num instanceof Float ? (Number)num : (Number)Float.valueOf(num.floatValue());
        }
        if (Double.class.equals((Object)argType) || Double.TYPE.equals(argType)) {
            return num instanceof Double ? (Number)num : (Number)num.doubleValue();
        }
        return num;
    }

    protected abstract FeatureInvoker<RESULT> getInvoker(String var1, McpRequest var2);

    protected abstract McpException notFound(String var1);

    protected Future<RESULT> execute(ExecutionModel executionModel, FeatureExecutionContext executionContext, final Callable<Uni<RESULT>> action) {
        final Promise ret = Promise.promise();
        if (executionModel == ExecutionModel.VIRTUAL_THREAD) {
            VirtualThreadsRecorder.getCurrent().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ((Uni)action.call()).subscribe().with(arg_0 -> ((Promise)ret).complete(arg_0), arg_0 -> ((Promise)ret).fail(arg_0));
                    }
                    catch (Throwable e) {
                        ret.fail(e);
                    }
                }
            });
        } else if (executionModel == ExecutionModel.WORKER_THREAD) {
            Vertx.currentContext().executeBlocking((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    try {
                        ((Uni)action.call()).subscribe().with(arg_0 -> ((Promise)ret).complete(arg_0), arg_0 -> ((Promise)ret).fail(arg_0));
                    }
                    catch (Throwable e) {
                        ret.fail(e);
                    }
                    return null;
                }
            }, false);
        } else {
            try {
                action.call().subscribe().with(arg_0 -> ((Promise)ret).complete(arg_0), arg_0 -> ((Promise)ret).fail(arg_0));
            }
            catch (Throwable e) {
                ret.fail(e);
            }
        }
        return ret.future();
    }

    protected McpLog log(String key, String loggerName, ArgumentProviders argProviders) {
        Logger logger = this.loggers.computeIfAbsent(key, k -> Logger.getLogger((String)loggerName));
        return new McpLogImpl(argProviders.connection()::logLevel, logger, key, argProviders.sender());
    }

    private String logKey(FeatureMetadata<?> metadata) {
        return metadata.feature().toString().toLowerCase() + ":" + metadata.info().name();
    }

    protected void notifyConnections(String method) {
        for (McpConnectionBase c : this.connectionManager) {
            c.send(Messages.newNotification(method));
        }
    }

    protected Map<Type, DefaultValueConverter<?>> defaultValueConverters() {
        return Map.of();
    }

    protected Object convert(String value, Type type) {
        Class clazz;
        if (String.class.equals((Object)type)) {
            return value;
        }
        type = FeatureManagerBase.box(type);
        DefaultValueConverter<?> converter = this.defaultValueConverters().get(type);
        if (converter != null) {
            return converter.convert(value);
        }
        if (type instanceof Class && (clazz = (Class)type).isEnum()) {
            for (Object constant : clazz.getEnumConstants()) {
                if (!constant.toString().equalsIgnoreCase(value)) continue;
                return constant;
            }
        }
        throw new IllegalArgumentException("Unable to convert the default value for argument type [" + String.valueOf(type) + "] - provide a custom converter implementation");
    }

    static Type box(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (!clazz.isPrimitive()) {
                return type;
            }
            if (clazz.equals(Boolean.TYPE)) {
                return Boolean.class;
            }
            if (clazz.equals(Character.TYPE)) {
                return Character.class;
            }
            if (clazz.equals(Byte.TYPE)) {
                return Byte.class;
            }
            if (clazz.equals(Short.TYPE)) {
                return Short.class;
            }
            if (clazz.equals(Integer.TYPE)) {
                return Integer.class;
            }
            if (clazz.equals(Long.TYPE)) {
                return Long.class;
            }
            if (clazz.equals(Float.TYPE)) {
                return Float.class;
            }
            if (clazz.equals(Double.TYPE)) {
                return Double.class;
            }
        }
        return type;
    }

    private static synchronized Instant nextTimestamp() {
        Instant ts = Instant.now();
        if (ts.isAfter(lastTimestamp)) {
            lastTimestamp = ts;
            return ts;
        }
        lastTimestamp = ts = lastTimestamp.plus(1L, ChronoUnit.MILLIS);
        return ts;
    }

    record FeatureExecutionContext(ArgumentProviders argProviders, McpRequest mcpRequest) {
    }

    static interface FeatureInvoker<R> {
        public ExecutionModel executionModel();

        public Uni<R> call(ArgumentProviders var1);
    }

    protected static abstract class FeatureDefinitionInfoBase<ARGUMENTS, RESPONSE>
    implements FeatureManager.FeatureInfo,
    FeatureInvoker<RESPONSE> {
        protected final String name;
        protected final String description;
        protected final String serverName;
        protected final Instant createdAt;
        protected final Function<ARGUMENTS, RESPONSE> fun;
        protected final Function<ARGUMENTS, Uni<RESPONSE>> asyncFun;
        protected final boolean runOnVirtualThread;

        protected FeatureDefinitionInfoBase(String name, String description, String serverName, Function<ARGUMENTS, RESPONSE> fun, Function<ARGUMENTS, Uni<RESPONSE>> asyncFun, boolean runOnVirtualThread) {
            this.name = name;
            this.description = description;
            this.serverName = serverName;
            this.createdAt = FeatureManagerBase.nextTimestamp();
            this.fun = fun;
            this.asyncFun = asyncFun;
            this.runOnVirtualThread = runOnVirtualThread;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String description() {
            return this.description;
        }

        @Override
        public String serverName() {
            return this.serverName;
        }

        @Override
        public boolean isMethod() {
            return false;
        }

        @Override
        public Instant createdAt() {
            return this.createdAt;
        }

        @Override
        public ExecutionModel executionModel() {
            if (this.runOnVirtualThread) {
                return ExecutionModel.VIRTUAL_THREAD;
            }
            return this.fun != null ? ExecutionModel.WORKER_THREAD : ExecutionModel.EVENT_LOOP;
        }

        protected abstract ARGUMENTS createArguments(ArgumentProviders var1);

        @Override
        public Uni<RESPONSE> call(ArgumentProviders argumentProviders) {
            ARGUMENTS args = this.createArguments(argumentProviders);
            Uni ret = this.fun != null ? Uni.createFrom().item(this.fun.apply(args)) : this.asyncFun.apply(args);
            return ret;
        }
    }

    protected static abstract class FeatureDefinitionBase<INFO extends FeatureManager.FeatureInfo, ARGUMENTS, RESPONSE, THIS extends FeatureDefinitionBase<INFO, ARGUMENTS, RESPONSE, THIS>> {
        protected final String name;
        protected String description;
        protected Function<ARGUMENTS, RESPONSE> fun;
        protected Function<ARGUMENTS, Uni<RESPONSE>> asyncFun;
        protected boolean runOnVirtualThread;
        protected String serverName;

        protected FeatureDefinitionBase(String name) {
            this.name = Objects.requireNonNull(name);
            this.serverName = "<default>";
        }

        protected THIS self() {
            return (THIS)this;
        }

        public THIS setDescription(String description) {
            this.description = Objects.requireNonNull(description);
            return this.self();
        }

        public THIS setServerName(String serverName) {
            this.serverName = Objects.requireNonNull(serverName);
            return this.self();
        }

        public THIS setHandler(Function<ARGUMENTS, RESPONSE> fun, boolean runOnVirtualThread) {
            this.fun = Objects.requireNonNull(fun);
            this.runOnVirtualThread = runOnVirtualThread;
            return this.self();
        }

        public THIS setAsyncHandler(Function<ARGUMENTS, Uni<RESPONSE>> asyncFun) {
            this.asyncFun = Objects.requireNonNull(asyncFun);
            return this.self();
        }

        protected void validate() {
            this.validate(true);
        }

        protected void validate(boolean requireDescription) {
            if (this.fun == null && this.asyncFun == null) {
                throw new IllegalStateException("Either sync or async logic must be set");
            }
            if (this.name == null) {
                throw new IllegalStateException("Name must be set");
            }
            if (requireDescription && this.description == null) {
                throw new IllegalStateException("Description must be set");
            }
        }
    }

    class FeatureMetadataInvoker<RESPONSE>
    implements FeatureInvoker<RESPONSE> {
        protected final FeatureMetadata<RESPONSE> metadata;
        private final Instant createdAt;

        FeatureMetadataInvoker(FeatureMetadata<RESPONSE> metadata) {
            this.metadata = metadata;
            this.createdAt = FeatureManagerBase.nextTimestamp();
        }

        @Override
        public ExecutionModel executionModel() {
            return this.metadata.executionModel();
        }

        public Instant createdAt() {
            return this.createdAt;
        }

        @Override
        public Uni<RESPONSE> call(ArgumentProviders argProviders) {
            Invoker<Object, Object> invoker = this.metadata.invoker();
            Object[] arguments = FeatureManagerBase.this.prepareArguments(this.metadata, argProviders);
            try {
                Function<Object, Uni<RESPONSE>> resultMapper = this.metadata.resultMapper();
                Object ret = invoker.invoke(null, arguments);
                ret = FeatureManagerBase.this.wrapResult(ret, this.metadata, argProviders);
                return resultMapper.apply(ret);
            }
            catch (Throwable e) {
                return Uni.createFrom().failure(e);
            }
        }
    }
}

