/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server;

import com.fasterxml.jackson.annotation.JsonValue;
import io.quarkiverse.mcp.server.ModelPreferences;
import io.quarkiverse.mcp.server.SamplingMessage;
import io.quarkiverse.mcp.server.SamplingResponse;
import io.smallrye.mutiny.Uni;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public interface SamplingRequest {
    public long maxTokens();

    public List<SamplingMessage> messages();

    public List<String> stopSequences();

    public String systemPrompt();

    public BigDecimal temperature();

    public IncludeContext includeContext();

    public ModelPreferences modelPreferences();

    public Map<String, Object> metadata();

    public Uni<SamplingResponse> send();

    default public SamplingResponse sendAndAwait() {
        return (SamplingResponse)this.send().await().indefinitely();
    }

    public static interface Builder {
        public Builder addMessage(SamplingMessage var1);

        public Builder setMaxTokens(long var1);

        public Builder setTemperature(BigDecimal var1);

        public Builder setSystemPrompt(String var1);

        public Builder setIncludeContext(IncludeContext var1);

        public Builder setModelPreferences(ModelPreferences var1);

        public Builder setMetadata(Map<String, Object> var1);

        public Builder setStopSequences(List<String> var1);

        public Builder setTimeout(Duration var1);

        public SamplingRequest build();
    }

    public static enum IncludeContext {
        ALL_SERVERS,
        NONE,
        THIS_SERVER;


        @JsonValue
        public String getValue() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case ALL_SERVERS -> "allServers";
                case NONE -> "none";
                case THIS_SERVER -> "thisServer";
            };
        }
    }
}

