/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server;

import io.quarkiverse.mcp.server.ProgressToken;
import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import java.math.BigDecimal;
import java.util.function.Function;

public interface ProgressTracker {
    public ProgressToken token();

    public void advanceAndForget(BigDecimal var1);

    @CheckReturnValue
    public Uni<Void> advance(BigDecimal var1);

    default public void advanceAndForget() {
        this.advanceAndForget(this.step());
    }

    default public void advanceAndForget(long value) {
        this.advanceAndForget(new BigDecimal(value));
    }

    default public void advanceAndForget(double value) {
        this.advanceAndForget(new BigDecimal(value));
    }

    public BigDecimal progress();

    public BigDecimal total();

    public BigDecimal step();

    public static interface Builder {
        public Builder setTotal(long var1);

        public Builder setTotal(double var1);

        public Builder setDefaultStep(long var1);

        public Builder setDefaultStep(double var1);

        public Builder setMessageBuilder(Function<BigDecimal, String> var1);

        public ProgressTracker build();
    }
}

