/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server;

import io.smallrye.mutiny.Uni;
import io.vertx.core.json.JsonObject;
import java.time.Instant;
import java.util.function.Function;

public interface FeatureManager<INFO extends FeatureInfo>
extends Iterable<INFO> {

    public static interface FeatureDefinition<INFO extends FeatureInfo, ARGUMENTS, RESPONSE, THIS extends FeatureDefinition<INFO, ARGUMENTS, RESPONSE, THIS>> {
        public THIS setDescription(String var1);

        public THIS setServerName(String var1);

        default public THIS setHandler(Function<ARGUMENTS, RESPONSE> fun) {
            return this.setHandler(fun, false);
        }

        public THIS setHandler(Function<ARGUMENTS, RESPONSE> var1, boolean var2);

        public THIS setAsyncHandler(Function<ARGUMENTS, Uni<RESPONSE>> var1);

        public INFO register();
    }

    public static interface FeatureInfo
    extends Comparable<FeatureInfo> {
        public String name();

        public String description();

        public String serverName();

        public boolean isMethod();

        public Instant createdAt();

        @Override
        default public int compareTo(FeatureInfo o) {
            int result = this.createdAt().compareTo(o.createdAt());
            return result == 0 ? this.name().compareTo(o.name()) : result;
        }

        public JsonObject asJson();
    }
}

