/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.quarkiverse.mcp.server.ResourceContents;
import io.quarkiverse.mcp.server.TextResourceContents;
import java.util.Base64;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record BlobResourceContents(String uri, String blob, String mimeType) implements ResourceContents
{
    public BlobResourceContents {
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        if (blob == null) {
            throw new IllegalArgumentException("blob must not be null");
        }
    }

    public static BlobResourceContents create(String uri, String blob) {
        return new BlobResourceContents(uri, blob, null);
    }

    public static BlobResourceContents create(String uri, byte[] blob) {
        return new BlobResourceContents(uri, Base64.getMimeEncoder().encodeToString(blob), null);
    }

    @Override
    public ResourceContents.Type type() {
        return ResourceContents.Type.BLOB;
    }

    @Override
    public TextResourceContents asText() {
        throw new IllegalArgumentException("Not a text");
    }

    @Override
    public BlobResourceContents asBlob() {
        return this;
    }
}

