/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.deployment;

import io.quarkiverse.mcp.server.AudioContent;
import io.quarkiverse.mcp.server.BlobResourceContents;
import io.quarkiverse.mcp.server.Content;
import io.quarkiverse.mcp.server.DefaultValueConverter;
import io.quarkiverse.mcp.server.EmbeddedResource;
import io.quarkiverse.mcp.server.ImageContent;
import io.quarkiverse.mcp.server.InitialCheck;
import io.quarkiverse.mcp.server.ModelHint;
import io.quarkiverse.mcp.server.ModelPreferences;
import io.quarkiverse.mcp.server.PromptFilter;
import io.quarkiverse.mcp.server.PromptMessage;
import io.quarkiverse.mcp.server.PromptResponse;
import io.quarkiverse.mcp.server.ResourceContents;
import io.quarkiverse.mcp.server.ResourceFilter;
import io.quarkiverse.mcp.server.ResourceResponse;
import io.quarkiverse.mcp.server.ResourceTemplateFilter;
import io.quarkiverse.mcp.server.Role;
import io.quarkiverse.mcp.server.SamplingMessage;
import io.quarkiverse.mcp.server.SamplingRequest;
import io.quarkiverse.mcp.server.TextContent;
import io.quarkiverse.mcp.server.TextResourceContents;
import io.quarkiverse.mcp.server.ToolFilter;
import io.quarkiverse.mcp.server.ToolManager;
import io.quarkiverse.mcp.server.ToolResponse;
import io.quarkiverse.mcp.server.WrapBusinessError;
import io.quarkiverse.mcp.server.deployment.DefaultValueConverterBuildItem;
import io.quarkiverse.mcp.server.deployment.DotNames;
import io.quarkiverse.mcp.server.deployment.FeatureMethodBuildItem;
import io.quarkiverse.mcp.server.deployment.ServerNameBuildItem;
import io.quarkiverse.mcp.server.runtime.BuiltinDefaultValueConverters;
import io.quarkiverse.mcp.server.runtime.EncoderMapper;
import io.quarkiverse.mcp.server.runtime.ExecutionModel;
import io.quarkiverse.mcp.server.runtime.Feature;
import io.quarkiverse.mcp.server.runtime.FeatureArgument;
import io.quarkiverse.mcp.server.runtime.FeatureMetadata;
import io.quarkiverse.mcp.server.runtime.FeatureMethodInfo;
import io.quarkiverse.mcp.server.runtime.JsonTextContentEncoder;
import io.quarkiverse.mcp.server.runtime.JsonTextResourceContentsEncoder;
import io.quarkiverse.mcp.server.runtime.McpMetadata;
import io.quarkiverse.mcp.server.runtime.McpServerRecorder;
import io.quarkiverse.mcp.server.runtime.NotificationManagerImpl;
import io.quarkiverse.mcp.server.runtime.PromptCompletionManagerImpl;
import io.quarkiverse.mcp.server.runtime.PromptEncoderResultMapper;
import io.quarkiverse.mcp.server.runtime.PromptManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceContentsEncoderResultMapper;
import io.quarkiverse.mcp.server.runtime.ResourceManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateCompletionManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResponseHandlers;
import io.quarkiverse.mcp.server.runtime.ResultMappers;
import io.quarkiverse.mcp.server.runtime.SamplingRequestImpl;
import io.quarkiverse.mcp.server.runtime.ToolEncoderResultMapper;
import io.quarkiverse.mcp.server.runtime.ToolManagerImpl;
import io.quarkiverse.mcp.server.runtime.WrapBusinessErrorInterceptor;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.InvokerFactoryBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InvokerBuilder;
import io.quarkus.arc.processor.KotlinUtils;
import io.quarkus.arc.processor.Types;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.execannotations.ExecutionModelAnnotationsAllowedBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.Gizmo;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import jakarta.annotation.Priority;
import jakarta.enterprise.invoke.Invoker;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class McpServerProcessor {
    private static final Logger LOG = Logger.getLogger(McpServerProcessor.class);
    private static final Map<DotName, Feature> ANNOTATION_TO_FEATURE = Map.of(DotNames.PROMPT, Feature.PROMPT, DotNames.COMPLETE_PROMPT, Feature.PROMPT_COMPLETE, DotNames.RESOURCE, Feature.RESOURCE, DotNames.RESOURCE_TEMPLATE, Feature.RESOURCE_TEMPLATE, DotNames.COMPLETE_RESOURCE_TEMPLATE, Feature.RESOURCE_TEMPLATE_COMPLETE, DotNames.TOOL, Feature.TOOL, DotNames.LANGCHAIN4J_TOOL, Feature.TOOL, DotNames.NOTIFICATION, Feature.NOTIFICATION);
    private static final String DEFAULT_VALUE = "defaultValue";
    private static final Set<org.jboss.jandex.Type> PROMPT_TYPES = Set.of(ClassType.create((DotName)DotNames.PROMPT_RESPONSE), ClassType.create((DotName)DotNames.PROMPT_MESSAGE));
    private static final Set<org.jboss.jandex.Type> COMPLETE_TYPES = Set.of(ClassType.create((DotName)DotNames.COMPLETE_RESPONSE), ClassType.create((DotName)DotNames.STRING));
    private static final Set<org.jboss.jandex.Type> TOOL_TYPES = Set.of(ClassType.create((DotName)DotNames.TOOL_RESPONSE), ClassType.create((DotName)DotNames.CONTENT), ClassType.create((DotName)DotNames.TEXT_CONTENT), ClassType.create((DotName)DotNames.IMAGE_CONTENT), ClassType.create((DotName)DotNames.EMBEDDED_RESOURCE), ClassType.create((DotName)DotNames.STRING));
    static final Set<org.jboss.jandex.Type> RESOURCE_TYPES = Set.of(ClassType.create((DotName)DotNames.RESOURCE_RESPONSE), ClassType.create((DotName)DotNames.RESOURCE_CONTENTS), ClassType.create((DotName)DotNames.TEXT_RESOURCE_CONTENTS), ClassType.create((DotName)DotNames.BLOB_RESOURCE_CONTENTS));

    McpServerProcessor() {
    }

    @BuildStep
    void addBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        AdditionalBeanBuildItem.Builder unremovable = AdditionalBeanBuildItem.builder().setUnremovable();
        unremovable.addBeanClass("io.quarkiverse.mcp.server.runtime.ConnectionManager");
        unremovable.addBeanClass(ResponseHandlers.class);
        unremovable.addBeanClasses(new Class[]{PromptManagerImpl.class, ToolManagerImpl.class, ResourceManagerImpl.class, PromptCompletionManagerImpl.class, ResourceTemplateManagerImpl.class, ResourceTemplateCompletionManagerImpl.class, NotificationManagerImpl.class});
        unremovable.addBeanClasses(new Class[]{JsonTextContentEncoder.class, JsonTextResourceContentsEncoder.class});
        unremovable.addBeanClasses(new Class[]{ToolEncoderResultMapper.class, ResourceContentsEncoderResultMapper.class, PromptEncoderResultMapper.class});
        additionalBeans.produce((BuildItem)unremovable.build());
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{WrapBusinessError.class, WrapBusinessErrorInterceptor.class}));
    }

    @BuildStep
    void autoScopes(BuildProducer<AutoAddScopeBuildItem> autoScopes) {
        autoScopes.produce((BuildItem)AutoAddScopeBuildItem.builder().containsAnnotations((DotName[])ANNOTATION_TO_FEATURE.keySet().toArray(DotName[]::new)).anyMethodMatches(this::isFeatureMethod).defaultScope(BuiltinScope.SINGLETON).build());
        autoScopes.produce((BuildItem)AutoAddScopeBuildItem.builder().implementsInterface(DotName.createSimple(ToolFilter.class)).defaultScope(BuiltinScope.SINGLETON).build());
        autoScopes.produce((BuildItem)AutoAddScopeBuildItem.builder().implementsInterface(DotName.createSimple(PromptFilter.class)).defaultScope(BuiltinScope.SINGLETON).build());
        autoScopes.produce((BuildItem)AutoAddScopeBuildItem.builder().implementsInterface(DotName.createSimple(ResourceFilter.class)).defaultScope(BuiltinScope.SINGLETON).build());
        autoScopes.produce((BuildItem)AutoAddScopeBuildItem.builder().implementsInterface(DotName.createSimple(ResourceTemplateFilter.class)).defaultScope(BuiltinScope.SINGLETON).build());
        autoScopes.produce((BuildItem)AutoAddScopeBuildItem.builder().implementsInterface(DotName.createSimple(InitialCheck.class)).defaultScope(BuiltinScope.SINGLETON).build());
    }

    @BuildStep
    ExecutionModelAnnotationsAllowedBuildItem executionModelAnnotations(final TransformedAnnotationsBuildItem transformedAnnotations) {
        final Set<DotName> featureAnnotations = ANNOTATION_TO_FEATURE.keySet();
        return new ExecutionModelAnnotationsAllowedBuildItem((Predicate)new Predicate<MethodInfo>(){

            @Override
            public boolean test(MethodInfo method) {
                return Annotations.containsAny((Collection)transformedAnnotations.getAnnotations((AnnotationTarget)method), (Iterable)featureAnnotations);
            }
        });
    }

    @BuildStep
    void collectFeatureMethods(BeanDiscoveryFinishedBuildItem beanDiscovery, InvokerFactoryBuildItem invokerFactory, List<DefaultValueConverterBuildItem> defaultValueConverters, CombinedIndexBuildItem combinedIndex, BuildProducer<FeatureMethodBuildItem> features, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        String message;
        List<Throwable> wrongUsages = this.findWrongAnnotationUsage(combinedIndex, errors);
        if (!wrongUsages.isEmpty()) {
            errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(wrongUsages));
        }
        HashMap<Feature, List> found = new HashMap<Feature, List>();
        for (BeanInfo bean : beanDiscovery.beanStream().classBeans().filter(this::hasFeatureMethod)) {
            ClassInfo beanClass = ((AnnotationTarget)bean.getTarget().get()).asClass();
            for (MethodInfo methodInfo : beanClass.methods()) {
                AnnotationValue annotations;
                AnnotationValue descValue;
                AnnotationValue value;
                String name;
                AnnotationInstance featureAnnotation = this.getFeatureAnnotation(methodInfo);
                if (featureAnnotation == null) continue;
                Feature feature = this.getFeature(featureAnnotation);
                this.validateFeatureMethod(methodInfo, feature, featureAnnotation, defaultValueConverters, combinedIndex.getComputingIndex());
                if (feature == Feature.PROMPT_COMPLETE || feature == Feature.RESOURCE_TEMPLATE_COMPLETE) {
                    name = featureAnnotation.value().asString();
                } else {
                    AnnotationValue nameValue = featureAnnotation.value("name");
                    String string = name = nameValue != null ? nameValue.asString() : methodInfo.name();
                }
                String description = feature == Feature.TOOL && methodInfo.hasDeclaredAnnotation(DotNames.LANGCHAIN4J_TOOL) ? ((value = featureAnnotation.value()) != null ? Arrays.stream(value.asStringArray()).collect(Collectors.joining()) : "") : (feature == Feature.NOTIFICATION ? featureAnnotation.value().asEnum() : ((descValue = featureAnnotation.value("description")) != null ? descValue.asString() : ""));
                InvokerBuilder invokerBuilder = invokerFactory.createInvoker(bean, methodInfo).withInstanceLookup();
                String uri = null;
                String mimeType = null;
                ToolManager.ToolAnnotations toolAnnotations = null;
                if (feature == Feature.RESOURCE) {
                    uriValue = featureAnnotation.value("uri");
                    uri = uriValue != null ? uriValue.asString() : null;
                    mimeTypeValue = featureAnnotation.value("mimeType");
                    mimeType = mimeTypeValue != null ? mimeTypeValue.asString() : null;
                } else if (feature == Feature.RESOURCE_TEMPLATE) {
                    uriValue = featureAnnotation.value("uriTemplate");
                    uri = uriValue != null ? uriValue.asString() : null;
                    mimeTypeValue = featureAnnotation.value("mimeType");
                    mimeType = mimeTypeValue != null ? mimeTypeValue.asString() : null;
                } else if (feature == Feature.TOOL && (annotations = featureAnnotation.value("annotations")) != null) {
                    AnnotationInstance annotationsAnnotation = annotations.asNested();
                    AnnotationValue titleValue = annotationsAnnotation.value("title");
                    AnnotationValue readOnlyHintValue = annotationsAnnotation.value("readOnlyHint");
                    AnnotationValue destructiveHintValue = annotationsAnnotation.value("destructiveHint");
                    AnnotationValue idempotentHintValue = annotationsAnnotation.value("idempotentHint");
                    AnnotationValue openWorldHintValue = annotationsAnnotation.value("openWorldHint");
                    toolAnnotations = new ToolManager.ToolAnnotations(titleValue != null ? titleValue.asString() : null, readOnlyHintValue != null ? readOnlyHintValue.asBoolean() : false, destructiveHintValue != null ? destructiveHintValue.asBoolean() : true, idempotentHintValue != null ? idempotentHintValue.asBoolean() : false, openWorldHintValue != null ? openWorldHintValue.asBoolean() : true);
                }
                String server = "<default>";
                AnnotationInstance serverAnotation = methodInfo.declaredAnnotation(DotNames.MCP_SERVER);
                if (serverAnotation == null) {
                    serverAnotation = methodInfo.declaringClass().declaredAnnotation(DotNames.MCP_SERVER);
                }
                if (serverAnotation != null) {
                    server = serverAnotation.value().asString();
                }
                FeatureMethodBuildItem fm = new FeatureMethodBuildItem(bean, methodInfo, invokerBuilder.build(), name, description, uri, mimeType, feature, toolAnnotations, server);
                features.produce((BuildItem)fm);
                found.compute(feature, (f, list) -> {
                    if (list == null) {
                        list = new ArrayList<FeatureMethodBuildItem>();
                    }
                    list.add(fm);
                    return list;
                });
            }
        }
        for (List featureMethods : found.values()) {
            Map<String, List> byName = featureMethods.stream().collect(Collectors.toMap(this::getDuplicateValidationName, List::of, (v1, v2) -> {
                ArrayList list = new ArrayList();
                list.addAll(v1);
                list.addAll(v2);
                return list;
            }));
            for (Map.Entry<String, List> entry : byName.entrySet()) {
                if (entry.getValue().size() <= 1) continue;
                message = "Duplicate feature method found for %s:\n\t%s".formatted(entry.getKey(), entry.getValue().stream().map(Object::toString).collect(Collectors.joining("\n\t")));
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException(message)}));
            }
        }
        List resources = (List)found.get(Feature.RESOURCE);
        if (resources != null) {
            Map<String, List> byUri = resources.stream().collect(Collectors.toMap(FeatureMethodBuildItem::getUri, List::of, (v1, v2) -> {
                ArrayList list = new ArrayList();
                list.addAll(v1);
                list.addAll(v2);
                return list;
            }));
            for (List list2 : byUri.values()) {
                if (list2.size() <= 1) continue;
                String string = "Duplicate resource uri found:\n\t%s".formatted(list2.stream().map(Object::toString).collect(Collectors.joining("\n\t")));
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException(string)}));
            }
        }
        List prompts = (List)found.get(Feature.PROMPT);
        List promptCompletions = (List)found.get(Feature.PROMPT_COMPLETE);
        if (promptCompletions != null) {
            for (FeatureMethodBuildItem featureMethodBuildItem : promptCompletions) {
                if (prompts != null && !prompts.stream().noneMatch(p -> p.getName().equals(completion.getName()))) continue;
                message = "Prompt %s does not exist for completion: %s".formatted(new Object[]{featureMethodBuildItem.getName(), featureMethodBuildItem});
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException(message)}));
            }
        }
        List list3 = (List)found.get(Feature.RESOURCE_TEMPLATE);
        List list4 = (List)found.get(Feature.RESOURCE_TEMPLATE_COMPLETE);
        if (list4 != null) {
            for (FeatureMethodBuildItem completion : list4) {
                if (list3 != null && !list3.stream().noneMatch(p -> p.getName().equals(completion.getName()))) continue;
                String message3 = "Resource template %s does not exist for completion: %s".formatted(new Object[]{completion.getName(), completion});
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException(message3)}));
            }
        }
    }

    private List<Throwable> findWrongAnnotationUsage(CombinedIndexBuildItem combinedIndex, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        ArrayList<Throwable> wrongUsages = new ArrayList<Throwable>();
        for (Map.Entry<DotName, Feature> e : ANNOTATION_TO_FEATURE.entrySet()) {
            this.findWrongMethods(combinedIndex.getIndex(), e.getKey(), e.getValue(), wrongUsages);
        }
        return wrongUsages;
    }

    private void findWrongMethods(IndexView index, DotName annotationName, Feature feature, List<Throwable> wrongUsages) {
        for (AnnotationInstance annotation : index.getAnnotations(annotationName)) {
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            if (Modifier.isStatic(annotation.target().asMethod().flags())) {
                wrongUsages.add(new IllegalStateException(String.valueOf(feature) + " method must not be static: " + McpServerProcessor.methodDesc(annotation.target().asMethod())));
                continue;
            }
            if (!annotation.target().asMethod().declaringClass().isInterface()) continue;
            wrongUsages.add(new IllegalStateException(String.valueOf(feature) + " method must not be declared on an interface: " + McpServerProcessor.methodDesc(annotation.target().asMethod())));
        }
    }

    private String getDuplicateValidationName(FeatureMethodBuildItem featureMethod) {
        if (featureMethod.getFeature() == Feature.PROMPT_COMPLETE || featureMethod.getFeature() == Feature.RESOURCE_TEMPLATE_COMPLETE) {
            AnnotationValue value;
            MethodParameterInfo argument = featureMethod.getMethod().parameters().stream().filter(p -> this.providerFrom(p.type()) == FeatureArgument.Provider.PARAMS).findFirst().orElseThrow();
            String argumentName = argument.name();
            AnnotationInstance completeArg = argument.declaredAnnotation(DotNames.COMPLETE_ARG);
            if (completeArg != null && (value = completeArg.value()) != null) {
                argumentName = value.asString();
            }
            return featureMethod.getName() + argumentName;
        }
        return featureMethod.getName();
    }

    private AnnotationInstance getFeatureAnnotation(MethodInfo method) {
        for (AnnotationInstance annotation : method.declaredAnnotations()) {
            if (!ANNOTATION_TO_FEATURE.containsKey(annotation.name())) continue;
            return annotation;
        }
        return null;
    }

    private Feature getFeature(AnnotationInstance annotation) {
        Feature ret = ANNOTATION_TO_FEATURE.get(annotation.name());
        if (ret != null) {
            return ret;
        }
        throw new IllegalStateException();
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void generateMetadata(McpServerRecorder recorder, RecorderContext recorderContext, BeanDiscoveryFinishedBuildItem beanDiscovery, List<FeatureMethodBuildItem> featureMethods, TransformedAnnotationsBuildItem transformedAnnotations, List<DefaultValueConverterBuildItem> defaultValueConverters, List<ServerNameBuildItem> serverNames, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, true);
        String metadataClassName = "io.quarkiverse.mcp.server.runtime.McpMetadata_Impl";
        ClassCreator metadataCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(metadataClassName).interfaces(new Class[]{McpMetadata.class}).build();
        boolean isResourceManagerUsed = false;
        boolean isResourceTemplateManagerUsed = false;
        boolean isPromptManagerUsed = false;
        boolean isToolManagerUsed = false;
        for (InjectionPointInfo ip : beanDiscovery.getInjectionPoints()) {
            if (ip.getRequiredType().name().equals((Object)DotNames.RESOURCE_MANAGER)) {
                isResourceManagerUsed = true;
                continue;
            }
            if (ip.getRequiredType().name().equals((Object)DotNames.RESOURCE_TEMPLATE_MANAGER)) {
                isResourceTemplateManagerUsed = true;
                continue;
            }
            if (ip.getRequiredType().name().equals((Object)DotNames.PROMPT_MANAGER)) {
                isPromptManagerUsed = true;
                continue;
            }
            if (!ip.getRequiredType().name().equals((Object)DotNames.TOOL_MANAGER)) continue;
            isToolManagerUsed = true;
        }
        MethodCreator isResourceManagerUsedMethod = metadataCreator.getMethodCreator("isResourceManagerUsed", Boolean.TYPE, new Class[0]);
        isResourceManagerUsedMethod.returnValue(isResourceManagerUsedMethod.load(isResourceManagerUsed));
        MethodCreator isResourceTemplateManagerUsedMethod = metadataCreator.getMethodCreator("isResourceTemplateManagerUsed", Boolean.TYPE, new Class[0]);
        isResourceTemplateManagerUsedMethod.returnValue(isResourceTemplateManagerUsedMethod.load(isResourceTemplateManagerUsed));
        MethodCreator isPromptManagerUsedMethod = metadataCreator.getMethodCreator("isPromptManagerUsed", Boolean.TYPE, new Class[0]);
        isPromptManagerUsedMethod.returnValue(isPromptManagerUsedMethod.load(isPromptManagerUsed));
        MethodCreator isToolManagerUsedMethod = metadataCreator.getMethodCreator("isToolManagerUsed", Boolean.TYPE, new Class[0]);
        isToolManagerUsedMethod.returnValue(isToolManagerUsedMethod.load(isToolManagerUsed));
        AtomicInteger counter = new AtomicInteger();
        MethodCreator promptsMethod = metadataCreator.getMethodCreator("prompts", List.class, new Class[0]);
        ResultHandle retPrompts = Gizmo.newArrayList((BytecodeCreator)promptsMethod);
        for (FeatureMethodBuildItem prompt : featureMethods.stream().filter(FeatureMethodBuildItem::isPrompt).toList()) {
            this.processFeatureMethod(counter, metadataCreator, promptsMethod, prompt, retPrompts, transformedAnnotations, DotNames.PROMPT_ARG);
        }
        promptsMethod.returnValue(retPrompts);
        MethodCreator promptCompletionsMethod = metadataCreator.getMethodCreator("promptCompletions", List.class, new Class[0]);
        ResultHandle retPromptCompletions = Gizmo.newArrayList((BytecodeCreator)promptCompletionsMethod);
        for (FeatureMethodBuildItem promptCompletion : featureMethods.stream().filter(FeatureMethodBuildItem::isPromptComplete).toList()) {
            this.processFeatureMethod(counter, metadataCreator, promptCompletionsMethod, promptCompletion, retPromptCompletions, transformedAnnotations, DotNames.COMPLETE_ARG);
        }
        promptCompletionsMethod.returnValue(retPromptCompletions);
        MethodCreator toolsMethod = metadataCreator.getMethodCreator("tools", List.class, new Class[0]);
        ResultHandle retTools = Gizmo.newArrayList((BytecodeCreator)toolsMethod);
        for (FeatureMethodBuildItem tool : featureMethods.stream().filter(FeatureMethodBuildItem::isTool).toList()) {
            this.processFeatureMethod(counter, metadataCreator, toolsMethod, tool, retTools, transformedAnnotations, tool.getMethod().hasDeclaredAnnotation(DotNames.LANGCHAIN4J_TOOL) ? DotNames.LANGCHAIN4J_P : DotNames.TOOL_ARG);
        }
        toolsMethod.returnValue(retTools);
        MethodCreator resourcesMethod = metadataCreator.getMethodCreator("resources", List.class, new Class[0]);
        ResultHandle retResources = Gizmo.newArrayList((BytecodeCreator)resourcesMethod);
        for (FeatureMethodBuildItem resource : featureMethods.stream().filter(FeatureMethodBuildItem::isResource).toList()) {
            this.processFeatureMethod(counter, metadataCreator, resourcesMethod, resource, retResources, transformedAnnotations, null);
        }
        resourcesMethod.returnValue(retResources);
        MethodCreator resourceTemplatesMethod = metadataCreator.getMethodCreator("resourceTemplates", List.class, new Class[0]);
        ResultHandle retResourceTemplates = Gizmo.newArrayList((BytecodeCreator)resourceTemplatesMethod);
        for (FeatureMethodBuildItem resourceTemplate : featureMethods.stream().filter(FeatureMethodBuildItem::isResourceTemplate).toList()) {
            this.processFeatureMethod(counter, metadataCreator, resourceTemplatesMethod, resourceTemplate, retResourceTemplates, transformedAnnotations, DotNames.RESOURCE_TEMPLATE_ARG);
        }
        resourceTemplatesMethod.returnValue(retResourceTemplates);
        MethodCreator resourceTemplateCompletionsMethod = metadataCreator.getMethodCreator("resourceTemplateCompletions", List.class, new Class[0]);
        ResultHandle retResourceTemplateCompletions = Gizmo.newArrayList((BytecodeCreator)resourceTemplateCompletionsMethod);
        for (FeatureMethodBuildItem resourceTemplateCompletion : featureMethods.stream().filter(FeatureMethodBuildItem::isResourceTemplateComplete).toList()) {
            this.processFeatureMethod(counter, metadataCreator, resourceTemplateCompletionsMethod, resourceTemplateCompletion, retResourceTemplateCompletions, transformedAnnotations, DotNames.COMPLETE_ARG);
        }
        resourceTemplateCompletionsMethod.returnValue(retResourceTemplateCompletions);
        MethodCreator notificationsMethod = metadataCreator.getMethodCreator("notifications", List.class, new Class[0]);
        ResultHandle retNotifications = Gizmo.newArrayList((BytecodeCreator)notificationsMethod);
        for (FeatureMethodBuildItem notification : featureMethods.stream().filter(FeatureMethodBuildItem::isNotification).toList()) {
            this.processFeatureMethod(counter, metadataCreator, notificationsMethod, notification, retNotifications, transformedAnnotations, DotNames.NOTIFICATION);
        }
        notificationsMethod.returnValue(retNotifications);
        MethodCreator convertersMethod = metadataCreator.getMethodCreator("defaultValueConverters", Map.class, new Class[0]);
        ResultHandle retConverters = Gizmo.newHashMap((BytecodeCreator)convertersMethod);
        for (DefaultValueConverterBuildItem converter : defaultValueConverters) {
            ResultHandle converterType = Types.getTypeHandle((BytecodeCreator)convertersMethod, (org.jboss.jandex.Type)converter.getArgumentType());
            ResultHandle converterInstance = convertersMethod.newInstance(MethodDescriptor.ofConstructor((String)converter.getClassName(), (String[])new String[0]), new ResultHandle[0]);
            Gizmo.mapOperations((BytecodeCreator)convertersMethod).on(retConverters).put(converterType, converterInstance);
        }
        convertersMethod.returnValue(retConverters);
        MethodCreator serverNamesMethod = metadataCreator.getMethodCreator("serverNames", Set.class, new Class[0]);
        ResultHandle set = Gizmo.newHashSet((BytecodeCreator)serverNamesMethod);
        for (ServerNameBuildItem serverName : serverNames) {
            Gizmo.setOperations((BytecodeCreator)serverNamesMethod).on(set).add(serverNamesMethod.load(serverName.getName()));
        }
        serverNamesMethod.returnValue(set);
        metadataCreator.close();
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(McpMetadata.class).scope(Singleton.class)).setRuntimeInit().runtimeValue(recorderContext.newInstance(metadataClassName)).done());
    }

    @BuildStep
    void registerForReflection(List<FeatureMethodBuildItem> featureMethods, List<DefaultValueConverterBuildItem> defaultValueConverters, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchies) {
        for (FeatureMethodBuildItem m : featureMethods) {
            for (org.jboss.jandex.Type paramType : m.getMethod().parameterTypes()) {
                if (paramType.kind() == Type.Kind.PRIMITIVE || paramType.name().equals((Object)DotNames.STRING) || paramType.name().equals((Object)DotNames.MCP_CONNECTION) || paramType.name().equals((Object)DotNames.MCP_LOG) || paramType.name().equals((Object)DotNames.REQUEST_ID) || paramType.name().equals((Object)DotNames.REQUEST_URI) || paramType.name().equals((Object)DotNames.PROGRESS) || paramType.name().equals((Object)DotNames.ROOTS) || paramType.name().equals((Object)DotNames.SAMPLING) || paramType.name().equals((Object)DotNames.CANCELLATION)) continue;
                reflectiveHierarchies.produce((BuildItem)ReflectiveHierarchyBuildItem.builder((org.jboss.jandex.Type)paramType).build());
            }
        }
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])((String[])defaultValueConverters.stream().map(DefaultValueConverterBuildItem::getClassName).toList().toArray(String[]::new))).constructors().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{Content.class, TextContent.class, ImageContent.class, EmbeddedResource.class, AudioContent.class, PromptResponse.class, PromptMessage.class, ToolResponse.class, FeatureMethodInfo.class, FeatureArgument.class, ResourceResponse.class, ResourceContents.class, TextResourceContents.class, BlobResourceContents.class, Role.class, SamplingMessage.class, ModelPreferences.class, ModelHint.class, SamplingRequest.IncludeContext.class, SamplingRequestImpl.class}).methods().build());
        reflectiveHierarchies.produce((BuildItem)ReflectiveHierarchyBuildItem.builder(List.class).build());
        reflectiveHierarchies.produce((BuildItem)ReflectiveHierarchyBuildItem.builder(Map.class).build());
    }

    @BuildStep
    AdditionalIndexedClassesBuildItem indexBuiltinDefaultValueConverters() {
        return new AdditionalIndexedClassesBuildItem(new String[]{BuiltinDefaultValueConverters.class.getName(), BuiltinDefaultValueConverters.BooleanConverter.class.getName(), BuiltinDefaultValueConverters.ByteConverter.class.getName(), BuiltinDefaultValueConverters.ShortConverter.class.getName(), BuiltinDefaultValueConverters.IntegerConverter.class.getName(), BuiltinDefaultValueConverters.LongConverter.class.getName(), BuiltinDefaultValueConverters.FloatConverter.class.getName(), BuiltinDefaultValueConverters.DoubleConverter.class.getName(), BuiltinDefaultValueConverters.CharacterConverter.class.getName()});
    }

    @BuildStep
    public void collectDefaultValueConverters(CombinedIndexBuildItem combinedIndex, BuildProducer<DefaultValueConverterBuildItem> converters) {
        HashMap<org.jboss.jandex.Type, List> found = new HashMap<org.jboss.jandex.Type, List>();
        for (ClassInfo converter : combinedIndex.getIndex().getAllKnownImplementations(DefaultValueConverter.class)) {
            if (converter.isAbstract()) continue;
            if (!Modifier.isPublic(converter.flags())) {
                LOG.warnf("Non-public default value converter ignored: %s", (Object)converter);
                continue;
            }
            if (!converter.hasNoArgsConstructor()) {
                LOG.warnf("Default value converter that does not declare a no-args constructor ignored: %s", (Object)converter);
                continue;
            }
            AnnotationInstance priorityAnnotation = converter.annotation(Priority.class);
            int priority = priorityAnnotation != null ? priorityAnnotation.value().asInt() : 0;
            List typeParams = JandexUtil.resolveTypeParameters((DotName)converter.name(), (DotName)DotNames.DEFAULT_VALUE_CONVERTER, (IndexView)combinedIndex.getComputingIndex());
            org.jboss.jandex.Type argumentType = (org.jboss.jandex.Type)typeParams.get(0);
            found.compute(argumentType, (k, v) -> {
                if (v == null) {
                    v = new ArrayList<DefaultValueConverterBuildItem>();
                }
                v.add(new DefaultValueConverterBuildItem(priority, converter.name().toString(), argumentType));
                return v;
            });
        }
        for (List list : found.values()) {
            list.sort(Comparator.comparingInt(DefaultValueConverterBuildItem::getPriority).reversed());
            converters.produce((BuildItem)((DefaultValueConverterBuildItem)((Object)list.get(0))));
        }
    }

    private void validateFeatureMethod(MethodInfo method, Feature feature, AnnotationInstance featureAnnotation, List<DefaultValueConverterBuildItem> defaultValueConverters, IndexView index) {
        if (Modifier.isStatic(method.flags())) {
            throw new IllegalStateException(String.valueOf(feature) + " method must not be static: " + McpServerProcessor.methodDesc(method));
        }
        if (Modifier.isPrivate(method.flags())) {
            throw new IllegalStateException(String.valueOf(feature) + " method must not be private: " + McpServerProcessor.methodDesc(method));
        }
        if (method.returnType().kind() == Type.Kind.VOID && feature != Feature.NOTIFICATION) {
            throw new IllegalStateException(String.valueOf(feature) + " method may not return void: " + McpServerProcessor.methodDesc(method));
        }
        switch (feature) {
            case PROMPT: {
                this.validatePromptMethod(method);
                break;
            }
            case PROMPT_COMPLETE: {
                this.validatePromptCompleteMethod(method);
                break;
            }
            case TOOL: {
                this.validateToolMethod(method, defaultValueConverters, index);
                break;
            }
            case RESOURCE: {
                this.validateResourceMethod(method);
                break;
            }
            case RESOURCE_TEMPLATE: {
                this.validateResourceTemplateMethod(method, featureAnnotation);
                break;
            }
            case RESOURCE_TEMPLATE_COMPLETE: {
                this.validateResourceTemplateCompleteMethod(method);
                break;
            }
            case NOTIFICATION: {
                this.validateNotificationMethod(method);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported feature: " + String.valueOf(feature));
            }
        }
    }

    private void validatePromptMethod(MethodInfo method) {
        List<MethodParameterInfo> parameters = this.parameters(method);
        for (MethodParameterInfo param : parameters) {
            if (param.type().name().equals((Object)DotNames.STRING)) continue;
            throw new IllegalStateException("Prompt method must only consume String parameters: " + McpServerProcessor.methodDesc(method));
        }
    }

    private void validatePromptCompleteMethod(MethodInfo method) {
        org.jboss.jandex.Type type = method.returnType();
        if (DotNames.UNI.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            type = (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0);
        }
        if (DotNames.LIST.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            type = (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0);
        }
        if (!COMPLETE_TYPES.contains(type)) {
            throw new IllegalStateException("Unsupported Prompt complete method return type: " + McpServerProcessor.methodDesc(method));
        }
        List<MethodParameterInfo> parameters = this.parameters(method);
        if (parameters.size() != 1 || !parameters.get(0).type().name().equals((Object)DotNames.STRING)) {
            throw new IllegalStateException("Prompt complete must consume exactly one String argument: " + McpServerProcessor.methodDesc(method));
        }
    }

    private void validateResourceTemplateCompleteMethod(MethodInfo method) {
        org.jboss.jandex.Type type = method.returnType();
        if (DotNames.UNI.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            type = (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0);
        }
        if (DotNames.LIST.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            type = (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0);
        }
        if (!COMPLETE_TYPES.contains(type)) {
            throw new IllegalStateException("Unsupported Resource template complete method return type: " + McpServerProcessor.methodDesc(method));
        }
        List<MethodParameterInfo> parameters = this.parameters(method);
        if (parameters.size() != 1 || !parameters.get(0).type().name().equals((Object)DotNames.STRING)) {
            throw new IllegalStateException("Resource template complete must consume exactly one String argument: " + McpServerProcessor.methodDesc(method));
        }
    }

    private void validateToolMethod(MethodInfo method, List<DefaultValueConverterBuildItem> defaultValueConverters, IndexView index) {
        for (MethodParameterInfo p : method.parameters()) {
            ClassInfo pclazz;
            AnnotationValue defaultValueValue;
            AnnotationInstance toolArg = p.annotation(DotNames.TOOL_ARG);
            if (toolArg == null || (defaultValueValue = toolArg.value(DEFAULT_VALUE)) == null || p.type().name().equals((Object)DotNames.STRING) || p.type().kind() == Type.Kind.CLASS && (pclazz = index.getClassByName(p.type().name())) != null && pclazz.isEnum()) continue;
            Object argType = p.type().kind() == Type.Kind.PRIMITIVE ? PrimitiveType.box((PrimitiveType)p.type().asPrimitiveType()) : p.type();
            if (!defaultValueConverters.stream().noneMatch(arg_0 -> McpServerProcessor.lambda$validateToolMethod$9((org.jboss.jandex.Type)argType, arg_0))) continue;
            throw new IllegalStateException("No matching default value converter found for argument type [" + String.valueOf(p.type()) + "] declared on: " + String.valueOf(p));
        }
    }

    private boolean useEncoder(org.jboss.jandex.Type type, Set<org.jboss.jandex.Type> types) {
        if (DotNames.UNI.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            type = (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0);
        }
        if (DotNames.LIST.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            type = (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0);
        }
        return !types.contains(type);
    }

    private void validateResourceMethod(MethodInfo method) {
        List<MethodParameterInfo> parameters = this.parameters(method);
        if (!parameters.isEmpty()) {
            throw new IllegalStateException("Resource method may only accept built-in parameter types" + McpServerProcessor.methodDesc(method));
        }
    }

    private void validateResourceTemplateMethod(MethodInfo method, AnnotationInstance featureAnnotation) {
        AnnotationValue uriTemplateValue = featureAnnotation.value("uriTemplate");
        if (uriTemplateValue == null) {
            throw new IllegalStateException("URI template not found");
        }
        ResourceTemplateManagerImpl.VariableMatcher variableMatcher = ResourceTemplateManagerImpl.createMatcherFromUriTemplate((String)uriTemplateValue.asString());
        List<MethodParameterInfo> parameters = this.parameters(method);
        for (MethodParameterInfo param : parameters) {
            if (!param.type().name().equals((Object)DotNames.STRING)) {
                throw new IllegalStateException("Resource template method must only consume String parameters: " + McpServerProcessor.methodDesc(method));
            }
            if (variableMatcher.variables().contains(param.name())) continue;
            throw new IllegalStateException("Parameter [" + param.name() + "] does not match an URI template variable: " + McpServerProcessor.methodDesc(method));
        }
    }

    private void validateNotificationMethod(MethodInfo method) {
        if (!(method.returnType().kind() == Type.Kind.VOID || method.returnType().name().equals((Object)DotNames.UNI) && ((org.jboss.jandex.Type)method.returnType().asParameterizedType().arguments().get(0)).name().equals((Object)DotName.createSimple(Void.class)))) {
            throw new IllegalStateException("Notification method must return void or Uni<Void>");
        }
        List parameters = method.parameters();
        for (MethodParameterInfo param : parameters) {
            if (param.type().name().equals((Object)DotNames.MCP_CONNECTION) || param.type().name().equals((Object)DotNames.MCP_LOG) || param.type().name().equals((Object)DotNames.ROOTS) || param.type().name().equals((Object)DotNames.SAMPLING)) continue;
            throw new IllegalStateException("Notification methods may only consume built-in parameter types [McpConnection, McpLog, Roots, Sampling]: " + McpServerProcessor.methodDesc(method));
        }
    }

    private List<MethodParameterInfo> parameters(MethodInfo method) {
        return method.parameters().stream().filter(p -> this.providerFrom(p.type()) == FeatureArgument.Provider.PARAMS).toList();
    }

    private boolean hasFeatureMethod(BeanInfo bean) {
        ClassInfo beanClass = ((AnnotationTarget)bean.getTarget().get()).asClass();
        for (DotName annotationName : ANNOTATION_TO_FEATURE.keySet()) {
            if (!beanClass.hasAnnotation(annotationName)) continue;
            return true;
        }
        return false;
    }

    private boolean isFeatureMethod(MethodInfo method) {
        if (!Modifier.isStatic(method.flags())) {
            for (DotName annotationName : ANNOTATION_TO_FEATURE.keySet()) {
                if (!method.hasDeclaredAnnotation(annotationName)) continue;
                return true;
            }
        }
        return false;
    }

    private void processFeatureMethod(AtomicInteger counter, ClassCreator clazz, MethodCreator method, FeatureMethodBuildItem featureMethod, ResultHandle retList, TransformedAnnotationsBuildItem transformedAnnotations, DotName argAnnotationName) {
        ResultHandle toolAnnotations;
        String methodName = "meta$" + counter.incrementAndGet();
        MethodCreator metaMethod = clazz.getMethodCreator(methodName, FeatureMetadata.class, new Class[0]);
        ResultHandle args = Gizmo.newArrayList((BytecodeCreator)metaMethod);
        for (MethodParameterInfo param : featureMethod.getMethod().parameters()) {
            String name = param.name();
            String description = "";
            boolean required = true;
            String defaultValue = null;
            if (argAnnotationName != null) {
                AnnotationInstance argAnnotation = param.declaredAnnotation(argAnnotationName);
                if (argAnnotation != null) {
                    AnnotationValue requiredValue;
                    AnnotationValue descriptionValue;
                    AnnotationValue nameValue = DotNames.LANGCHAIN4J_P.equals((Object)argAnnotationName) ? argAnnotation.value() : argAnnotation.value("name");
                    if (nameValue != null) {
                        name = nameValue.asString();
                    }
                    if ((descriptionValue = argAnnotation.value("description")) != null) {
                        description = descriptionValue.asString();
                    }
                    if ((requiredValue = argAnnotation.value("required")) != null) {
                        required = requiredValue.asBoolean();
                    } else if (DotNames.OPTIONAL.equals((Object)param.type().name()) || this.hasDefaultValue(param)) {
                        required = false;
                    }
                    AnnotationValue defaultValueValue = argAnnotation.value(DEFAULT_VALUE);
                    if (defaultValueValue != null) {
                        defaultValue = defaultValueValue.asString();
                    }
                } else if (DotNames.OPTIONAL.equals((Object)param.type().name())) {
                    required = false;
                }
            }
            ResultHandle type = Types.getTypeHandle((BytecodeCreator)metaMethod, (org.jboss.jandex.Type)param.type());
            ResultHandle provider = metaMethod.load((Enum)this.providerFrom(param.type()));
            ResultHandle arg = metaMethod.newInstance(MethodDescriptor.ofConstructor(FeatureArgument.class, (Class[])new Class[]{String.class, String.class, Boolean.TYPE, Type.class, String.class, FeatureArgument.Provider.class}), new ResultHandle[]{metaMethod.load(name), metaMethod.load(description), metaMethod.load(required), type, defaultValue != null ? metaMethod.load(defaultValue) : metaMethod.loadNull(), provider});
            Gizmo.listOperations((BytecodeCreator)metaMethod).on(args).add(arg);
        }
        if (featureMethod.isTool() && featureMethod.getToolAnnotations() != null) {
            ToolManager.ToolAnnotations annotations = featureMethod.getToolAnnotations();
            toolAnnotations = metaMethod.newInstance(MethodDescriptor.ofConstructor(ToolManager.ToolAnnotations.class, (Class[])new Class[]{String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}), new ResultHandle[]{annotations.title() == null ? metaMethod.loadNull() : metaMethod.load(annotations.title()), metaMethod.load(annotations.readOnlyHint()), metaMethod.load(annotations.destructiveHint()), metaMethod.load(annotations.idempotentHint()), metaMethod.load(annotations.openWorldHint())});
        } else {
            toolAnnotations = metaMethod.loadNull();
        }
        ResultHandle info = metaMethod.newInstance(MethodDescriptor.ofConstructor(FeatureMethodInfo.class, (Class[])new Class[]{String.class, String.class, String.class, String.class, List.class, String.class, ToolManager.ToolAnnotations.class, String.class}), new ResultHandle[]{metaMethod.load(featureMethod.getName()), metaMethod.load(featureMethod.getDescription()), featureMethod.getUri() == null ? metaMethod.loadNull() : metaMethod.load(featureMethod.getUri()), featureMethod.getMimeType() == null ? metaMethod.loadNull() : metaMethod.load(featureMethod.getMimeType()), args, metaMethod.load(featureMethod.getMethod().declaringClass().name().toString()), toolAnnotations, metaMethod.load(featureMethod.getServer())});
        ResultHandle invoker = metaMethod.newInstance(MethodDescriptor.ofConstructor((String)featureMethod.getInvoker().getClassName(), (String[])new String[0]), new ResultHandle[0]);
        ResultHandle executionModel = metaMethod.load((Enum)McpServerProcessor.executionModel(featureMethod.getMethod(), transformedAnnotations));
        ResultHandle resultMapper = this.getMapper((BytecodeCreator)metaMethod, featureMethod.getMethod().returnType(), featureMethod.getFeature());
        ResultHandle metadata = metaMethod.newInstance(MethodDescriptor.ofConstructor(FeatureMetadata.class, (Class[])new Class[]{Feature.class, FeatureMethodInfo.class, Invoker.class, ExecutionModel.class, Function.class}), new ResultHandle[]{metaMethod.load((Enum)featureMethod.getFeature()), info, invoker, executionModel, resultMapper});
        metaMethod.returnValue(metadata);
        Gizmo.listOperations((BytecodeCreator)method).on(retList).add(method.invokeVirtualMethod(metaMethod.getMethodDescriptor(), method.getThis(), new ResultHandle[0]));
    }

    private boolean hasDefaultValue(MethodParameterInfo param) {
        AnnotationInstance anno = param.annotation(DotNames.TOOL_ARG);
        if (anno == null) {
            anno = param.annotation(DotNames.PROMPT_ARG);
        }
        return anno != null && anno.value(DEFAULT_VALUE) != null;
    }

    private FeatureArgument.Provider providerFrom(org.jboss.jandex.Type type) {
        if (type.name().equals((Object)DotNames.MCP_CONNECTION)) {
            return FeatureArgument.Provider.MCP_CONNECTION;
        }
        if (type.name().equals((Object)DotNames.REQUEST_ID)) {
            return FeatureArgument.Provider.REQUEST_ID;
        }
        if (type.name().equals((Object)DotNames.MCP_LOG)) {
            return FeatureArgument.Provider.MCP_LOG;
        }
        if (type.name().equals((Object)DotNames.REQUEST_URI)) {
            return FeatureArgument.Provider.REQUEST_URI;
        }
        if (type.name().equals((Object)DotNames.PROGRESS)) {
            return FeatureArgument.Provider.PROGRESS;
        }
        if (type.name().equals((Object)DotNames.ROOTS)) {
            return FeatureArgument.Provider.ROOTS;
        }
        if (type.name().equals((Object)DotNames.SAMPLING)) {
            return FeatureArgument.Provider.SAMPLING;
        }
        if (type.name().equals((Object)DotNames.CANCELLATION)) {
            return FeatureArgument.Provider.CANCELLATION;
        }
        return FeatureArgument.Provider.PARAMS;
    }

    private ResultHandle getMapper(BytecodeCreator bytecode, org.jboss.jandex.Type returnType, Feature feature) {
        return switch (feature) {
            case Feature.PROMPT -> this.promptResultMapper(bytecode, returnType);
            case Feature.PROMPT_COMPLETE -> this.readResultMapper(bytecode, McpServerProcessor.createMapperClassSimpleName(Feature.PROMPT_COMPLETE, returnType, DotNames.COMPLETE_RESPONSE, c -> "String"));
            case Feature.TOOL -> this.toolResultMapper(bytecode, returnType);
            case Feature.RESOURCE, Feature.RESOURCE_TEMPLATE -> this.resourceResultMapper(bytecode, returnType);
            case Feature.RESOURCE_TEMPLATE_COMPLETE -> this.readResultMapper(bytecode, McpServerProcessor.createMapperClassSimpleName(Feature.RESOURCE_TEMPLATE_COMPLETE, returnType, DotNames.COMPLETE_RESPONSE, c -> "String"));
            case Feature.NOTIFICATION -> this.readResultMapper(bytecode, returnType.kind() == Type.Kind.VOID ? "ToUni" : "Identity");
            default -> throw new IllegalArgumentException("Unsupported feature: " + String.valueOf(feature));
        };
    }

    ResultHandle resourceResultMapper(BytecodeCreator bytecode, org.jboss.jandex.Type returnType) {
        if (this.useEncoder(returnType, RESOURCE_TYPES)) {
            return this.encoderResultMapper(Feature.RESOURCE, bytecode, returnType, ResourceContentsEncoderResultMapper.class);
        }
        return this.readResultMapper(bytecode, McpServerProcessor.createMapperClassSimpleName(Feature.RESOURCE, returnType, DotNames.RESOURCE_RESPONSE, c -> "Content"));
    }

    ResultHandle encoderResultMapper(Feature feature, BytecodeCreator bytecode, org.jboss.jandex.Type returnType, Class<?> mapperClazz) {
        ResultHandle container = bytecode.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle instance = bytecode.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), container, new ResultHandle[]{bytecode.loadClass(mapperClazz), bytecode.newArray(Annotation.class, 0)});
        ResultHandle mapper = bytecode.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instance, new ResultHandle[0]);
        if (DotNames.UNI.equals((Object)returnType.name())) {
            mapper = feature != Feature.PROMPT && DotNames.LIST.equals((Object)((org.jboss.jandex.Type)returnType.asParameterizedType().arguments().get(0)).name()) ? bytecode.invokeVirtualMethod(MethodDescriptor.ofMethod(mapperClazz, (String)"uniList", EncoderMapper.class, (Class[])new Class[0]), mapper, new ResultHandle[0]) : bytecode.invokeVirtualMethod(MethodDescriptor.ofMethod(mapperClazz, (String)"uni", EncoderMapper.class, (Class[])new Class[0]), mapper, new ResultHandle[0]);
        } else if (feature != Feature.PROMPT && DotNames.LIST.equals((Object)returnType.name())) {
            mapper = bytecode.invokeVirtualMethod(MethodDescriptor.ofMethod(mapperClazz, (String)"list", EncoderMapper.class, (Class[])new Class[0]), mapper, new ResultHandle[0]);
        }
        return mapper;
    }

    ResultHandle toolResultMapper(BytecodeCreator bytecode, org.jboss.jandex.Type returnType) {
        if (this.useEncoder(returnType, TOOL_TYPES)) {
            return this.encoderResultMapper(Feature.TOOL, bytecode, returnType, ToolEncoderResultMapper.class);
        }
        return this.readResultMapper(bytecode, McpServerProcessor.createMapperClassSimpleName(Feature.TOOL, returnType, DotNames.TOOL_RESPONSE, c -> this.isContent((DotName)c) ? "Content" : "String"));
    }

    ResultHandle promptResultMapper(BytecodeCreator bytecode, org.jboss.jandex.Type returnType) {
        if (this.useEncoder(returnType, PROMPT_TYPES)) {
            return this.encoderResultMapper(Feature.PROMPT, bytecode, returnType, PromptEncoderResultMapper.class);
        }
        return this.readResultMapper(bytecode, McpServerProcessor.createMapperClassSimpleName(Feature.PROMPT, returnType, DotNames.PROMPT_RESPONSE, c -> "OfMessage"));
    }

    static String createMapperClassSimpleName(Feature feature, org.jboss.jandex.Type returnType, DotName baseType, Function<DotName, String> componentMapper) {
        StringBuilder ret;
        if (returnType.name().equals((Object)baseType)) {
            return "ToUni";
        }
        org.jboss.jandex.Type type = returnType;
        if (feature == Feature.PROMPT_COMPLETE || feature == Feature.RESOURCE_TEMPLATE_COMPLETE) {
            ret = new StringBuilder("Complete");
        } else {
            String f = feature.toString();
            ret = new StringBuilder().append(f.charAt(0)).append(f.substring(1).toLowerCase());
        }
        if (DotNames.UNI.equals((Object)type.name())) {
            if ((type = (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0)).name().equals((Object)baseType)) {
                return "Identity";
            }
            ret.append("Uni");
        }
        if (DotNames.LIST.equals((Object)type.name())) {
            type = (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0);
            ret.append("List");
        }
        ret.append(componentMapper.apply(type.name()));
        return ret.toString();
    }

    private boolean isContent(DotName typeName) {
        return DotNames.CONTENT.equals((Object)typeName) || DotNames.TEXT_CONTENT.equals((Object)typeName) || DotNames.IMAGE_CONTENT.equals((Object)typeName) || DotNames.EMBEDDED_RESOURCE.equals((Object)typeName);
    }

    private ResultHandle readResultMapper(BytecodeCreator bytecode, String mapperClassSimpleName) {
        String mapperClassName = ResultMappers.class.getName() + "$" + mapperClassSimpleName;
        return bytecode.readStaticField(FieldDescriptor.of((String)mapperClassName, (String)"INSTANCE", (String)mapperClassName));
    }

    private static ExecutionModel executionModel(MethodInfo method, TransformedAnnotationsBuildItem transformedAnnotations) {
        if (KotlinUtils.isKotlinSuspendMethod((MethodInfo)method) && (transformedAnnotations.hasAnnotation((AnnotationTarget)method, DotNames.RUN_ON_VIRTUAL_THREAD) || transformedAnnotations.hasAnnotation((AnnotationTarget)method.declaringClass(), DotNames.RUN_ON_VIRTUAL_THREAD) || transformedAnnotations.hasAnnotation((AnnotationTarget)method, DotNames.BLOCKING) || transformedAnnotations.hasAnnotation((AnnotationTarget)method, DotNames.NON_BLOCKING))) {
            throw new IllegalStateException("Kotlin `suspend` functions in MCP components may not be annotated @Blocking, @NonBlocking or @RunOnVirtualThread: " + McpServerProcessor.methodDesc(method));
        }
        if (transformedAnnotations.hasAnnotation((AnnotationTarget)method, DotNames.RUN_ON_VIRTUAL_THREAD) || transformedAnnotations.hasAnnotation((AnnotationTarget)method.declaringClass(), DotNames.RUN_ON_VIRTUAL_THREAD)) {
            return ExecutionModel.VIRTUAL_THREAD;
        }
        if (transformedAnnotations.hasAnnotation((AnnotationTarget)method, DotNames.BLOCKING)) {
            return ExecutionModel.WORKER_THREAD;
        }
        if (transformedAnnotations.hasAnnotation((AnnotationTarget)method, DotNames.NON_BLOCKING)) {
            return ExecutionModel.EVENT_LOOP;
        }
        if (transformedAnnotations.hasAnnotation((AnnotationTarget)method, DotNames.TRANSACTIONAL) || transformedAnnotations.hasAnnotation((AnnotationTarget)method.declaringClass(), DotNames.TRANSACTIONAL)) {
            return ExecutionModel.WORKER_THREAD;
        }
        return McpServerProcessor.hasBlockingSignature(method) ? ExecutionModel.WORKER_THREAD : ExecutionModel.EVENT_LOOP;
    }

    static boolean hasBlockingSignature(MethodInfo method) {
        if (KotlinUtils.isKotlinSuspendMethod((MethodInfo)method)) {
            return false;
        }
        switch (method.returnType().kind()) {
            case VOID: 
            case CLASS: 
            case ARRAY: {
                return true;
            }
            case PARAMETERIZED_TYPE: {
                DotName name = method.returnType().asParameterizedType().name();
                return !name.equals((Object)DotNames.UNI) && !name.equals((Object)DotNames.MULTI);
            }
        }
        throw new IllegalStateException("Unsupported return type:" + McpServerProcessor.methodDesc(method));
    }

    private static String methodDesc(MethodInfo method) {
        StringBuilder builder = new StringBuilder().append(method.declaringClass().name().withoutPackagePrefix()).append("#").append(method.name()).append('(');
        Iterator it = method.parameterTypes().iterator();
        while (it.hasNext()) {
            builder.append(it.next());
            if (!it.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(')');
        return builder.toString();
    }

    private static /* synthetic */ boolean lambda$validateToolMethod$9(org.jboss.jandex.Type argType, DefaultValueConverterBuildItem c) {
        return c.getArgumentType().equals((Object)argType);
    }
}

