/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.deployment;

import io.quarkiverse.mcp.server.ToolManager;
import io.quarkiverse.mcp.server.runtime.Feature;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.InvokerInfo;
import io.quarkus.builder.item.MultiBuildItem;
import java.util.Objects;
import org.jboss.jandex.MethodInfo;

final class FeatureMethodBuildItem
extends MultiBuildItem {
    private final Feature feature;
    private final BeanInfo bean;
    private final InvokerInfo invoker;
    private final MethodInfo method;
    private final String name;
    private final String description;
    private final String uri;
    private final String mimeType;
    private final ToolManager.ToolAnnotations toolAnnotations;
    private final String server;

    FeatureMethodBuildItem(BeanInfo bean, MethodInfo method, InvokerInfo invoker, String name, String description, String uri, String mimeType, Feature feature, ToolManager.ToolAnnotations toolAnnotations, String server) {
        this.bean = Objects.requireNonNull(bean);
        this.method = Objects.requireNonNull(method);
        this.invoker = Objects.requireNonNull(invoker);
        this.feature = Objects.requireNonNull(feature);
        this.name = Objects.requireNonNull(name);
        this.description = description;
        this.uri = feature.requiresUri() ? Objects.requireNonNull(uri) : null;
        this.mimeType = mimeType;
        this.toolAnnotations = toolAnnotations;
        this.server = server;
    }

    BeanInfo getBean() {
        return this.bean;
    }

    MethodInfo getMethod() {
        return this.method;
    }

    InvokerInfo getInvoker() {
        return this.invoker;
    }

    String getName() {
        return this.name;
    }

    String getDescription() {
        return this.description;
    }

    String getUri() {
        return this.uri;
    }

    String getMimeType() {
        return this.mimeType;
    }

    Feature getFeature() {
        return this.feature;
    }

    ToolManager.ToolAnnotations getToolAnnotations() {
        return this.toolAnnotations;
    }

    String getServer() {
        return this.server;
    }

    boolean isTool() {
        return this.feature == Feature.TOOL;
    }

    boolean isPrompt() {
        return this.feature == Feature.PROMPT;
    }

    boolean isPromptComplete() {
        return this.feature == Feature.PROMPT_COMPLETE;
    }

    boolean isResource() {
        return this.feature == Feature.RESOURCE;
    }

    boolean isResourceTemplate() {
        return this.feature == Feature.RESOURCE_TEMPLATE;
    }

    boolean isResourceTemplateComplete() {
        return this.feature == Feature.RESOURCE_TEMPLATE_COMPLETE;
    }

    boolean isNotification() {
        return this.feature == Feature.NOTIFICATION;
    }

    public String toString() {
        return "FeatureMethodBuildItem [name=" + this.name + ", method=" + String.valueOf(this.method.declaringClass()) + "#" + this.method.name() + "(), feature=" + String.valueOf(this.feature) + "]";
    }
}

