/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.langchain4j.watsonx;

import dev.langchain4j.data.image.Image;
import dev.langchain4j.internal.Utils;
import io.quarkiverse.langchain4j.watsonx.bean.CosError;
import io.quarkiverse.langchain4j.watsonx.bean.WatsonxError;
import io.quarkiverse.langchain4j.watsonx.exception.BuiltinServiceException;
import io.quarkiverse.langchain4j.watsonx.exception.COSException;
import io.quarkiverse.langchain4j.watsonx.exception.WatsonxException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;

public class WatsonxUtils {
    public static <T> T retryOn(Callable<T> action) {
        int maxAttempts = 1;
        for (int i = 0; i <= maxAttempts; ++i) {
            try {
                return action.call();
            }
            catch (BuiltinServiceException | COSException | WatsonxException e) {
                if (WatsonxUtils.isTokenExpired(e)) continue;
                throw e;
            }
            catch (WebApplicationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Failed after " + maxAttempts + " attempts");
    }

    public static boolean isTokenExpired(Throwable exception) {
        COSException e;
        BuiltinServiceException e2;
        if (exception instanceof WatsonxException) {
            WatsonxException e3 = (WatsonxException)exception;
            if (e3.details() == null || e3.details().errors() == null || e3.details().errors().size() == 0) {
                return false;
            }
            Optional<Object> optional = Optional.empty();
            for (WatsonxError.Error error : e3.details().errors()) {
                Optional<WatsonxError.Code> c = error.codeToEnum();
                if (!c.isPresent() || !WatsonxError.Code.AUTHENTICATION_TOKEN_EXPIRED.equals((Object)c.get())) continue;
                optional = Optional.of(c.get());
                break;
            }
            if (optional.isPresent()) {
                return true;
            }
        } else if (exception instanceof BuiltinServiceException ? (e2 = (BuiltinServiceException)exception).statusCode().intValue() == Response.Status.UNAUTHORIZED.getStatusCode() && e2.details().equalsIgnoreCase("jwt expired") : exception instanceof COSException && (e = (COSException)exception).statusCode().intValue() == Response.Status.FORBIDDEN.getStatusCode() && e.details().getCode().equals((Object)CosError.Code.ACCESS_DENIED)) {
            return true;
        }
        return false;
    }

    public static String base64Image(Image image) {
        if (Objects.nonNull(image.base64Data())) {
            return image.base64Data();
        }
        try {
            switch (image.url().getScheme()) {
                case "http": 
                case "https": 
                case "file": {
                    break;
                }
                default: {
                    throw new RuntimeException("The only supported image schemes are: [http, https, file]");
                }
            }
            byte[] bytes = Utils.readBytes((String)image.url().toString());
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException("Error converting the image to base64, see the log for more details", e);
        }
    }
}

